
@extends( 
        ($theme =="white") ? 'layouts.white_theme':
     ( ($theme =="red") ? 'layouts.red_theme':
    (($theme =="green") ? 'layouts.green_theme':
    (($theme =="black") ? 'layouts.black_theme':
   ( ($theme =="blue") ?'layouts.blue_theme': 'layouts.yellow_theme' ))))
    )

@section('content')

<div class="section-header shadow-none">
  <h1>{{ __('Edit Add-on') }}</h1>
  <div class="section-header-breadcrumb">
        <div class="breadcrumb-item active"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></div>
        <div class="breadcrumb-item"><a href="{{ route('addon.index') }}">{{ __('Add-on') }}</a>
        </div>
        <div class="breadcrumb-item">{{ __('Edit Add-on') }}</div>
    </div>
</div>


  <div class="row">
    <div class="col-12">
      @include('common.demo')
     
      @include('common.errors')
      <div class="card">
        <div class="card-body">
                    <form method="POST" action="{{ route('addon.update', [$addon->uuid])}}">
                        @csrf
                        <input name="_method" type="hidden" value="PUT">

                        <div class="form-group row mb-4">
                            <label
                                class="col-form-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Name') }}:*</label>
                            <div class="col-sm-12 col-md-7">
                                <input id="addonname" type="text"
                                    class="form-control  @error('addonname') is-invalid @enderror"
                                    name="addonname" value="{{ old('addonname', $addon->name) }}"
                                    autocomplete="addonname" autofocus >

                                @error('addonname')
                                <div class="text-danger pt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row mb-4">
                                <label
                                    class="col-form-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Status') }}:*</label>
                                <div class="col-sm-12 col-md-7">
                                    <div class="custom-radio custom-control">
                                        <input class="custom-control-input" type="radio" name="status" id="active"
                                            value=1 {{ old('status', $addon->status) == 1 ? "checked" : "" }}>
                                        <label class="custom-control-label" for="active">
                                            {{ __('Active') }}
                                        </label>
                                    </div>
                                    <div class="custom-radio custom-control">
                                        <input class="custom-control-input" type="radio" name="status" id="inactive"
                                            value=0 {{ old('status', $addon->status) == 0 ? "checked" : "" }}>
                                        <label class="custom-control-label" for="inactive">
                                            {{ __('Inactive') }}
                                        </label>
                                    </div>
                                    
                                </div>
                            </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"></label>
                            <div class="col-sm-12 col-md-7">
                                <button type="submit" class="btn btn-custom">{{ __('Update') }}</button>
                            </div>
                        </div>
                    </form>

          
        </div>
      </div>
    </div>
  </div>
</div>
@endsection