@extends( 
        ($theme =="white") ? 'layouts.white_theme':
     ( ($theme =="red") ? 'layouts.red_theme':
    (($theme =="green") ? 'layouts.green_theme':
    (($theme =="black") ? 'layouts.black_theme':
   ( ($theme =="blue") ?'layouts.blue_theme': 'layouts.yellow_theme' ))))
    )
@section('content')

<div class="section-header shadow-none">
  <h1>{{ __('Add-on') }}</h1>
  <div class="section-header-breadcrumb">
        <div class="breadcrumb-item active"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></div>
        <div class="breadcrumb-item">{{ __('Available Add-ons') }}</div>
    </div>
</div>

<div class="section-body">
 

  <div class="row">
    <div class="col-12">
      @include('common.demo')
   
      @include('common.errors')
      <div class="card">
        <div class="card-header">
          <div class="inline-block float-sm-right mt-2 mt-sm-0">
            <a href="{{ route('addon.create') }}" class="btn btn-icon btn-custom"><i
                class="far fa-edit"></i>{{ __('Add Add-on') }}</a>
           
          </div>
        </div>
        <div class="card-body">
        @if (!count($addon))
          <div class="card-body">
            <div class="empty-state" data-height="400">
              <div class="empty-state-icon bg-danger">
                <i class="fas fa-question"></i>
              </div>
              <h2>{{ __('No add-ons added yet under') }} !!</h2>
              <p class="lead">
                {{ __('Sorry we cant find any data, to get rid of this message, make at least 1 entry') }}.
              </p>
              <a href="{{ route('addon.create') }}" class="btn btn-custom mt-4">{{ __('Create new One') }}</a>
            </div>
          </div>
          @else
          <div class="table-responsive">
            <table class="table table-striped" id="table-1">
              <thead>
                <tr class="text-center text-capitalize">
                  <th>{{ __('Name') }}</th>
                  <th>{{ __('Version') }}</th>
                  <th>{{ __('Status') }}</th>
                  <th>{{__('Settings')}}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
              @foreach ($addon as $add)
                <tr class="text-center">
                  <td class="text-left">{{ $add->name }}</td>
                  <td>{{ $add->version }}</td>
                  <td>
                    @if ($add->status == 1)
                    {{ __('Active') }}
                    @else
                    {{ __('Inactive') }}  
                    @endif
                  </td>
                  <td class="justify-content-center ">
                        <a href="{{$add->settings_url}}" class="btn btn-sm bg-transparent"><i
                            class="fa fa-cog text-primary" aria-hidden="true" title="{{ __('Settings') }}"></i></a>
                  </td>
                  <td class="justify-content-center form-inline">
                        <a href="{{ route('addon.edit', [$add->uuid]) }}" class="btn btn-sm bg-transparent"><i
                            class="far fa-edit text-primary" aria-hidden="true" title="{{ __('Edit') }}"></i></a>

                        @if (env('APP_ENV') != 'demo')
                        <form action="{{ route('addon.destroy', [$add->uuid]) }}" method="POST">
                          @method('DELETE')
                          @csrf
                          <button class="btn btn-sm bg-transparent" onclick="return confirm('Are you sure?')">
                            <i class="fa fa-trash text-danger" aria-hidden="true" title="{{ __('Delete') }}"></i>
                          </button>
                        </form>
                        @endif
                      </td>
                  @endforeach
              </tbody>
            </table>
            <br>
          </div>
          @endif
        </div>
      </div>
    </div>
    </div>
  </div>
</div>
@endsection
