<?php
$CI = get_instance();
$CI->load->database();
$CI->load->dbforge();

if($CI->db->get_where('settings', ['key' => 'offline_bank_information'])->num_rows() == 0){
	$CI->db->insert('settings', ['key' => 'offline_bank_information', 'value' => "Enter your bank information"]);
}

$addon = $CI->db->get_where('addons', ['unique_identifier' => 'offline_payment']);
if($addon->num_rows() > 0){
	$addon_details = $addon->row_array();
	$currency = 'USD';
	if($addon_details['version'] <= '1.2'){
		$data2['keys'] = json_encode(array());
		$data2['currency'] = $currency;
		$data2['enabled_test_mode'] = 0;
		$data2['status'] = 1;
		$data2['identifier'] = 'offline_payment';
		$data2['title'] = 'Offline payment';
		$data2['description'] = '';
		$data2['model_name'] = 'Offline_payment_model';
		$data2['is_addon'] = 1;
		$data2['created_at'] = time();
		$insert_id = $CI->db->insert('payment_gateways', $data2);
	}else{
		$insert_id = 0;
	}

}else{
	$data2['keys'] = json_encode(array());
	$data2['currency'] = 'USD';
	$data2['enabled_test_mode'] = 0;
	$data2['status'] = 1;
	$data2['identifier'] = 'offline_payment';
	$data2['title'] = 'Offline payment';
	$data2['description'] = '';
	$data2['model_name'] = 'Offline_payment_model';
	$data2['is_addon'] = 1;
	$data2['created_at'] = time();
	$insert_id = $CI->db->insert('payment_gateways', $data2);
}




if ($CI->db->table_exists('offline_payment') ){

}else{
	// CREATING FACEBOOK_MESSENGER TABLE
	$fields = array(
		'id' => array(
			'type' => 'INT',
			'constraint' => 11,
			'unsigned' => TRUE,
			'auto_increment' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'user_id' => array(
			'type' => 'INT',
			'constraint' => '11',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'amount' => array(
			'type' => 'VARCHAR',
			'constraint' => '255',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'course_id' => array(
			'type' => 'VARCHAR',
			'constraint' => '255',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'item_id' => array(
			'type' => 'VARCHAR',
			'constraint' => '255',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'item_type' => array(
			'type' => 'VARCHAR',
			'constraint' => '255',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'document_image' => array(
			'type' => 'VARCHAR',
			'constraint' => '255',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'timestamp' => array(
			'type' => 'VARCHAR',
			'constraint' => '255',
			'default' => null,
			'null' => TRUE,
			'collation' => 'utf8_unicode_ci'
		),
		'status' => array(
			'type' => 'INT',
			'constraint' => '11',
			'default' => 0,
			'collation' => 'utf8_unicode_ci'
		)
	);
	$CI->dbforge->add_field($fields);
	$CI->dbforge->add_key('id', TRUE);
	$attributes = array('collation' => "utf8_unicode_ci");
	$CI->dbforge->create_table('offline_payment', TRUE);
}




if ($CI->db->field_exists('item_id', 'offline_payment')){
        // some code...
}else{
	//ADD item_id COLUMN IN lesson TABLE 
	$item_id = array(
	    'item_id' => array(
	        'type' => 'VARCHAR',
			'constraint' => '255',
	        'collation' => 'utf8_unicode_ci'
	    )
	);
	$CI->dbforge->add_column('offline_payment', $item_id);

	$item_type = array(
	    'item_type' => array(
	        'type' => 'VARCHAR',
			'constraint' => '255',
	        'collation' => 'utf8_unicode_ci'
	    )
	);
	$CI->dbforge->add_column('offline_payment', $item_type);
}

foreach($CI->db->where('item_type', '')->get('offline_payment')->result_array() as $payment):
	$CI->db->where('id', $payment['id'])->update('offline_payment', ['item_type' => 'course', 'item_id' => $payment['course_id']]);
endforeach;