<?php
/* Mumara integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_mumara_class {
	var $default_parameters = array(
		"api-url" => "",
		"api-key" => "",
		"list" => "",
		"list-id" => "",
		"fields" => array('email' => '')
	);
	
	function __construct() {
		if (is_admin()) {
			add_filter('leform_providers', array(&$this, 'providers'), 10, 1);
			add_action('wp_ajax_leform-mumara-settings-html', array(&$this, "admin_settings_html"));
			add_action('wp_ajax_leform-mumara-list', array(&$this, "admin_lists"));
			add_action('wp_ajax_leform-mumara-fields', array(&$this, "admin_fields_html"));
		}
		add_filter('leform_integrations_do_mumara', array(&$this, 'front_submit'), 10, 2);
	}
	
	function providers($_providers) {
		if (!array_key_exists("mumara", $_providers)) $_providers["mumara"] = esc_html__('Mumara', 'leform');
		return $_providers;
	}
	
	function admin_settings_html() {
		global $wpdb, $leform;
		if (current_user_can('manage_options')) {
			if (array_key_exists('data', $_REQUEST)) {
				$data = json_decode(base64_decode(trim(stripslashes($_REQUEST['data']))), true);
				if (is_array($data)) $data = array_merge($this->default_parameters, $data);
				else $data = $this->default_parameters;
			} else $data = $this->default_parameters;
			$checkbox_id = $leform->random_string();
			$html = '
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('URL', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your Mumara URL.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="api-url" value="'.esc_html($data['api-url']).'" />
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('API Token', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your Mumara API Token.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="api-key" value="'.esc_html($data['api-key']).'" />
					<label class="leform-integrations-description">'.esc_html__('Enter your Mumara API Token. You can generate it in Mumara account (Settings >> API Key).', 'leform').'</label>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('List ID', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Select desired List ID.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-group leform-integrations-ajax-options">
						<input type="text" name="list" value="'.esc_html($data['list']).'" data-deps="api-url,api-key" readonly="readonly" />
						<input type="hidden" name="list-id" value="'.esc_html($data['list-id']).'" />
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Fields', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Map form fields to Mumara fields.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline">
						<table>
							<tr>
								<th>'.esc_html__('Email', 'leform').'</td>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" name="fields[email]" value="'.esc_html(array_key_exists('email', $data['fields']) ? $data['fields']['email'] : '').'" class="widefat" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
									<label class="leform-integrations-description">'.esc_html__('Email Address', 'leform').'</label>
								</td>
							</tr>
						</table>
					</div>
					<div class="leform-properties-pure leform-integrations-ajax-inline">';
			if (!empty($data['api-url']) && !empty($data['api-key'])) {
				$fields_data = $this->get_fields_html($data['api-url'], $data['api-key'], $data['fields']);
				if ($fields_data['status'] == 'OK') $html .= $fields_data['html'];
			}
			$html .= '
					</div>
					<a class="leform-button leform-button-small" onclick="return leform_integrations_ajax_inline_html(this);" data-inline="fields" data-deps="api-url,api-key"><i class="fas fa-download"></i><label>'.esc_html__('Load Fields', 'leform').'</label></a>
				</div>
			</div>';
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['html'] = $html;
			echo json_encode($return_object);
		}
		exit;
	}
	
	function admin_lists() {
		global $wpdb, $leform;
		$lists = array();
		if (current_user_can('manage_options')) {
			if (array_key_exists('deps', $_REQUEST)) {
				$deps = json_decode(base64_decode(trim(stripslashes($_REQUEST['deps']))), true);
				if (!is_array($deps)) $deps = null;
			} else $deps = null;

			if (!is_array($deps) || !array_key_exists('api-url', $deps) || empty($deps['api-url']) || !array_key_exists('api-key', $deps) || empty($deps['api-key'])) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid API Credentials.', 'leform'));
				echo json_encode($return_object);
				exit;
			}

			$result = $this->connect($deps['api-url'], $deps['api-key'], 'getLists');
			
			if(!$result || !is_array($result) || !array_key_exists('status', $result) || $result['status'] != 'success' || !array_key_exists('response', $result)) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid API Credentials.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			if (sizeof($result['response']) == 0) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('No lists found.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			foreach ($result['response'] as $list) {
				if (is_array($list)) {
					if (array_key_exists('id', $list) && array_key_exists('name', $list)) {
						$lists[$list['id']] = $list['name'];
					}
				}
			}
			
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['items'] = $lists;
			echo json_encode($return_object);
		}
		exit;
	}

	function admin_fields_html() {
		global $wpdb;
		if (current_user_can('manage_options')) {
			if (array_key_exists('deps', $_REQUEST)) {
				$deps = json_decode(base64_decode(trim(stripslashes($_REQUEST['deps']))), true);
				if (!is_array($deps)) $deps = null;
			} else $deps = null;
			if (!is_array($deps) || !array_key_exists('api-key', $deps) || empty($deps['api-key']) || !array_key_exists('api-url', $deps) || empty($deps['api-url'])) {
				$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid API Credentials.', 'leform'));
				echo json_encode($return_object);
				exit;
			}
			$return_object = $this->get_fields_html($deps['api-url'], $deps['api-key'], $this->default_parameters['fields']);
			echo json_encode($return_object);
		}
		exit;
	}

	function get_fields_html($_api_url, $_api_key, $_fields) {
		global $wpdb, $leform;
		$result = $this->connect($_api_url, $_api_key, 'getCustomFields');
		$fields_html = '';
		if(!$result || !is_array($result) || !array_key_exists('status', $result) || $result['status'] != 'success' || !array_key_exists('response', $result)) {
			return array('status' => 'ERROR', 'message' => esc_html__('Inavlid API Key.', 'leform'));
		}
		if (sizeof($result['response']) == 0) {
			return array('status' => 'ERROR', 'message' => esc_html__('No fields found.', 'leform'));
		}
		$fields_html = '
			<table>';
		foreach ($result['response'] as $field) {
			if (is_array($field)) {
				if (array_key_exists('tag', $field) && array_key_exists('name', $field)) {
					$fields_html .= '
				<tr>
					<th>'.esc_html($field['name']).'</td>
					<td>
						<div class="leform-input-shortcode-selector">
							<input type="text" name="fields['.esc_html($field['tag']).']" value="'.esc_html(array_key_exists($field['tag'], $_fields) ? $_fields[$field['tag']] : '').'" class="widefat" />
							<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
						</div>
						<label class="leform-integrations-description">'.esc_html($field['name'].' ('.$field['tag'].')').'</label>
					</td>
				</tr>';
				}
			}
		}
		$fields_html .= '
			</table>';
		return array('status' => 'OK', 'html' => $fields_html);
	}

	function front_submit($_result, $_data) {
		global $wpdb, $leform;
		$data = array_merge($this->default_parameters, $_data);
		if (empty($data['api-key']) || empty($data['api-url'])) return $_result;
		if (empty($data['fields']) || !is_array($data['fields'])) return $_result;
		if (empty($data['fields']['email']) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,19})$/i", $data['fields']['email'])) return $_result;

		$post_data = array(
			'email' => $data['fields']['email'], 
			'list_id' => $data['list-id'],
			'confirmation_status' => 1
		);
		foreach ($popup_options['mumara_fields'] as $key => $value) {
			if (!empty($value) && $key != 'email') {
				$post_data[$key] = $value;
			}
		}
		$result = $this->connect($data['api-url'], $data['api-key'], 'add-subscriber', 'POST', $post_data);
		return $_result;
	}
	
	function connect($_api_url, $_api_token, $_path, $_method = 'GET', $_data = null) {
		try {
			$url = rtrim($_api_url, '/').'/api/'.trim($_path, '/');
			
			if ($_method == 'GET') {
				$url .= (strpos($url, '?') === false ? '?' : '&').'api_token='.$_api_token;
			} else {
				$_data['api_token'] = $_api_token;
			}
			
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
			curl_setopt($ch, CURLOPT_TIMEOUT, 10);
			curl_setopt($ch, CURLOPT_USERAGENT, 'MumaraApi Client version 1.0');
			curl_setopt($ch, CURLOPT_AUTOREFERER , true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			if (is_array($_data) && !empty($_data)) {
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($_method));
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $_data);
			}
			$response = curl_exec($ch);
			curl_close($ch);
			$result = json_decode($response, true);
		} catch (Exception $e) {
			$result = false;
		}
		return $result;
	}
}
$leform_mumara = new leform_mumara_class();
?>