<?php
/* Omnisend integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_omnisend_class {
	var $default_parameters = array(
		"api-key" => "",
		"fields" => array(
			"email" => "",
			"firstName" => "",
			"lastName" => "",
			"gender" => "",
			"phone" => "",
			"birthdate" => "",
			"country" => "",
			"state" => "",
			"city" => "",
			"address" => "",
			"postalCode" => ""
		),
		"custom-names" => array(),
		"custom-values" => array()
	);
	var $fields_meta;
	function __construct() {
		$this->fields_meta = array(
			'email' => esc_html__('Email address', 'leform'),
			'firstName' => esc_html__('First name', 'leform'),
			'lastName' => esc_html__('Last name', 'leform'),
			'gender' => esc_html__('Gender', 'leform'),
			'phone' => esc_html__('Phone #', 'leform'),
			'birthdate' => esc_html__('Birtdate', 'leform'),
			'country' => esc_html__('Country', 'leform'),
			'state' => esc_html__('State', 'leform'),
			'city' => esc_html__('City', 'leform'),
			'address' => esc_html__('Address', 'leform'),
			'postalCode' => esc_html__('Postal Code', 'leform')
		);
		if (is_admin()) {
			add_filter('leform_providers', array(&$this, 'providers'), 10, 1);
			add_action('wp_ajax_leform-omnisend-settings-html', array(&$this, "admin_settings_html"));
		}
		add_filter('leform_integrations_do_omnisend', array(&$this, 'front_submit'), 10, 2);
	}
	
	function providers($_providers) {
		if (!array_key_exists("omnisend", $_providers)) $_providers["omnisend"] = esc_html__('Omnisend', 'leform');
		return $_providers;
	}
	
	function admin_settings_html() {
		global $wpdb, $leform;
		if (current_user_can('manage_options')) {
			if (array_key_exists('data', $_REQUEST)) {
				$data = json_decode(base64_decode(trim(stripslashes($_REQUEST['data']))), true);
				if (is_array($data)) $data = array_merge($this->default_parameters, $data);
				else $data = $this->default_parameters;
			} else $data = $this->default_parameters;
			$checkbox_id = $leform->random_string();
			$html = '
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('API Key', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter your Omnisend API Key.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="api-key" value="'.esc_html($data['api-key']).'" />
					<label class="leform-integrations-description">'.sprintf(esc_html__('Find your Omnisend API Key %shere%s.', 'leform'), '<a href="https://app.omnisend.com/#/my-account/integrations/api-keys" target="_blank">', '</a>').'</label>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Fields', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Map form fields to Omnisend fields.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline">
						<table>';
		foreach ($this->default_parameters['fields'] as $key => $value) {
			$html .= '
							<tr>
								<th>'.esc_html($this->fields_meta[$key]).'</td>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" name="fields['.$key.']" value="'.esc_html(array_key_exists($key, $data['fields']) ? $data['fields'][$key] : $value).'" class="widefat" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
									<label class="leform-integrations-description">'.esc_html($this->fields_meta[$key].' ('.$key.')').'</label>
								</td>
							</tr>';
		}
		$html .= '				
						</table>
					</div>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Custom Fields', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Configure Omnisend custom fields and map form fields to them.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline leform-integrations-custom" data-names="custom-names" data-values="custom-values">
						<table>
							<tr>
								<th>'.esc_html__('Name', 'leform').'</th>
								<td>'.esc_html__('Value', 'leform').'</td>
								<td style="width: 32px;"></td>
							</tr>';
		$i = 0;
		foreach ($data['custom-names'] as $key => $value) {
			if (empty($value)) continue;
			$html .= '
							<tr>
								<th>
									<input type="text" value="'.esc_html($value).'" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="'.esc_html(array_key_exists($key, $data['custom-values']) ? $data['custom-values'][$key] : '').'" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td class="leform-middle-center">'.($i > 0 ? '<a class="leform-integrations-custom-remove" href="#" onclick="jQuery(this).closest(\'tr\').remove(); return false;"><i class="fas fa-trash-alt"></i></a>' : '').'</td>
							</tr>';
			$i++;
		}
		if ($i == 0) {
			$html .= '
							<tr>
								<th>
									<input type="text" value="" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td></td>
							</tr>';
		}
		$html .= '				
							<tr style="display: none;" class="leform-integrations-custom-template">
								<th>
									<input type="text" value="" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td class="leform-middle-center"><a class="leform-integrations-custom-remove" href="#" onclick="jQuery(this).closest(\'tr\').remove(); return false;"><i class="fas fa-trash-alt"></i></a></td>
							</tr>
							<tr>
								<td colspan="3">
									<a class="leform-admin-button leform-admin-button-gray leform-admin-button-small" href="#" onclick="return leform_integrations_custom_add(this);"><i class="fas fa-plus"></i><label>'.esc_html__('Add Custom Field', 'leform').'</label></a>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>';
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['html'] = $html;
			echo json_encode($return_object);
		}
		exit;
	}
	
	function front_submit($_result, $_data) {
		global $wpdb, $leform;
		$data = array_merge($this->default_parameters, $_data);
		if (empty($data['api-key'])) return $_result;
		if (empty($data['fields']) || !is_array($data['fields'])) return $_result;
		if (empty($data['fields']['email']) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,19})$/i", $data['fields']['email'])) return $_result;

		$post_data = array(
			'optInIP' => $_SERVER['REMOTE_ADDR'],
			'optInDate' => date(DATE_ATOM),
			'status' => 'subscribed',
			'statusDate' => date(DATE_ATOM),
			'sendWelcomeEmail' => true
		);
		foreach($data['fields'] as $key => $value) {
			if (!empty($value)) $post_data[$key] = $data['fields'][$key];
		}
		if (!empty($data['custom-names'])) {
			$post_data['customProperties'] = array();
			foreach($data['custom-names'] as $key => $name) {
				$name = preg_replace('/[^a-zA-Z0-9_]/', '', $name);
				if (!empty($name) && !empty($data['custom-values'][$key])) $post_data['customProperties'][$name] = $data['custom-values'][$key];
			}
		}
		$result = $this->connect($data['api-key'], 'contacts', $post_data);
		return $_result;
	}
	
	function connect($_api_key, $_path, $_data = array(), $_method = '') {
		$headers = array(
			'Content-Type: application/json;charset=UTF-8',
			'Accept: application/json',
			'X-API-KEY: '.$_api_key
		);
		try {
			$url = 'https://api.omnisend.com/v3/'.ltrim($_path, '/');
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			if (!empty($_data)) {
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($_data));
			}
			if (!empty($_method)) {
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $_method);
			}
			curl_setopt($curl, CURLOPT_TIMEOUT, 120);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
			curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($curl);
			curl_close($curl);
			$result = json_decode($response, true);
		} catch (Exception $e) {
			$result = false;
		}
		return $result;
	}
}
$leform_omnisend = new leform_omnisend_class();
?>