<?php
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_admin_class {
	var $list_table;
	var $success_message = '';
	var $error_message = '';
	function __construct() {
		global $leform;
		if (is_admin()) {
			$version = get_option('leform-version', LEFORM_VERSION);
			$webfonts_version = get_option('leform-webfonts-version', 0);
			if (($version && $version < LEFORM_VERSION) || $webfonts_version < LEFORM_WEBFONTS_VERSION) {
				leform_class::activate();
				//add_action('admin_notices', array(&$this, 'admin_warning'));
			}
			
			add_action('admin_enqueue_scripts', array(&$this, 'admin_enqueue_scripts'));
			add_action('admin_head', array(&$this, 'admin_head'));
			add_action('admin_menu', array(&$this, 'admin_menu'), 1);
			add_action('admin_init', array(&$this, 'admin_init'));
			/* Personal Data - 2020-12-09 - begin */
			include_once(dirname(__FILE__).'/core-personal.php');
			$leform_personal = new leform_personal_data_class();
			/* Personal Data - 2020-12-09 - end */
		}
	}
	
	function admin_warning() {
		echo '
		<div class="error leform-error leform-error-animated"><p>'.sprintf(esc_html__('IMPORTANT! Please deactivate and activate "Green Forms" plugin %shere%s! It is necessary to sync database for additional functionality', 'leform'), '<a href="'.admin_url('plugins.php').'">', '</a>').'</p></div>';
	}

	function admin_enqueue_scripts() {
		global $leform;
		wp_enqueue_script("jquery");
		wp_enqueue_style('leform', $leform->plugins_url.'/css/admin.css', array(), LEFORM_VERSION);
		wp_enqueue_script('leform', $leform->plugins_url.'/js/admin.js', array('jquery'), LEFORM_VERSION);
		if (array_key_exists('page', $_GET) && ($_GET['page'] == 'leform' || substr($_GET['page'], 0, strlen('leform-')) == 'leform-')) {
			wp_enqueue_style('leform-front', $leform->plugins_url.'/css/style.css', array(), LEFORM_VERSION);
			wp_enqueue_style('tooltipster', $leform->plugins_url.'/css/tooltipster.bundle.min.css', array(), LEFORM_VERSION);
			wp_enqueue_script('tooltipster', $leform->plugins_url.'/js/tooltipster.bundle.min.js', array('jquery'), LEFORM_VERSION);
			wp_enqueue_style('leform-fa', $leform->plugins_url.'/css/leform-fa.css', array(), LEFORM_VERSION);
			wp_enqueue_style('leform-if', $leform->plugins_url.'/css/leform-if.css', array(), LEFORM_VERSION);
			wp_enqueue_style('font-awesome-5.7.2', $leform->plugins_url.'/css/fontawesome-all.min.css', array(), LEFORM_VERSION);
			wp_enqueue_style('material-icons-3.0.1', $leform->plugins_url.'/css/material-icons.css', array(), LEFORM_VERSION);
			wp_enqueue_style('airdatepicker', $leform->plugins_url.'/css/airdatepicker.css', array(), LEFORM_VERSION);
			wp_enqueue_script('airdatepicker', $leform->plugins_url.'/js/airdatepicker.js', array('jquery'), LEFORM_VERSION);
			wp_enqueue_script('chart', $leform->plugins_url.'/js/chart.min.js', array(), LEFORM_VERSION);
			wp_enqueue_script('jquery.mask', $leform->plugins_url.'/js/jquery.mask.min.js', array('jquery'), LEFORM_VERSION);
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_style('minicolors', $leform->plugins_url.'/css/jquery.minicolors.css', array(), LEFORM_VERSION);
			wp_enqueue_script('minicolors', $leform->plugins_url.'/js/jquery.minicolors.js', array('jquery'), LEFORM_VERSION, true);
			if ($leform->options['range-slider-enable'] == 'on') {
				wp_enqueue_style('ion.rangeSlider', $leform->plugins_url.'/css/ion.rangeSlider.css', array(), LEFORM_VERSION);
				wp_enqueue_script('ion.rangeSlider', $leform->plugins_url.'/js/ion.rangeSlider.js', array('jquery'), LEFORM_VERSION, true);
			}
			wp_enqueue_media();
			wp_enqueue_editor();
		}
	}
	
	function admin_head() {
		global $leform, $wpdb;
		$sql = "SELECT id, name, active FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' ORDER BY id DESC";
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		$gettingstarted_steps = array(
			"create-form" => array(
				array(
					"selector"	=> ".leform-toolbar",
					"class"		=> "bottom-left",
					"style"		=> "margin-top:10px;margin-left:50px;min-width:530px;",
					"text"		=> esc_html__('Add input field or any other element to the form by clicking relevant button on Elements Toolbar.', 'leform')
				),
				array (
					"selector"	=> ".leform-header-settings",
					"class"		=> "left",
					"style"		=> "top:-25px;left:60px;min-width:530px;",
					"text"		=> esc_html__('Click this button to check and adjust form settings (styles, notifications, integrations, payments, etc.).', 'leform')
				),
				array (
					"selector"	=> ".leform-pages-bar",
					"class"		=> "bottom-left",
					"style"		=> "margin-top:10px;margin-left:60px;",
					"text"		=> esc_html__('Add pages (steps) to create multi-step forms.', 'leform')
				),
				array (
					"selector"	=> ".leform-header-save",
					"class"		=> "bottom-right",
					"style"		=> "margin-top:10px;margin-right:50px;min-width:400px;",
					"text"		=> esc_html__('Save changes by clicking this button.', 'leform')
				)
			),
			"form-saved" => array(
				array (
					"selector"	=> ".leform-header-preview",
					"class"		=> "bottom-right",
					"style"		=> "margin-top:0px;margin-right:20px;min-width:400px;",
					"text"		=> esc_html__('Click this button to preview the form.', 'leform')
				),
				array (
					"selector"	=> ".leform-header-using",
					"class"		=> "bottom-right",
					"style"		=> "margin-top:0px;margin-right:20px;min-width:400px;",
					"text"		=> esc_html__('Click this button and check how to use or embed the form.', 'leform')
				)
			),
			"element-properties" => array(
				array(
					"selector"	=> "#leform-form-1",
					"class"		=> "bottom-left",
					"style"		=> "margin-top:10px;margin-left:50px;",
					"text"		=> esc_html__('Click mouse right button over element to access its properties.', 'leform')
				)
			)
		);
		echo '
<script>
	'.(defined('UAP_CORE') ? 'var leform_uap_core = true; ' : '').'var leform_ajax_handler = "'.admin_url('admin-ajax.php').'";var leform_plugin_url = "'.$leform->plugins_url.'"; var leform_forms_encoded = "'.base64_encode(json_encode($rows)).'"; var leform_gettingstarted_enable = "'.$leform->options['gettingstarted-enable'].'"; var leform_gettingsstarted_encoded = "'.base64_encode(json_encode($gettingstarted_steps)).'";
	leform_gettingstarted_steps = JSON.parse(leform_decode64(leform_gettingsstarted_encoded));
</script>';
	}

	function admin_menu() {
		global $leform;
		if ($leform->demo_mode) {
			$cap = "read";
		} else $cap = "manage_options";
		add_menu_page(
			"Green Forms"
			, "Green Forms"
			, $cap
			, "leform"
			, array(&$this, 'admin_forms')
			, 'none'
			, 56
		);
		add_submenu_page(
			"leform"
			, esc_html__('Forms', 'leform')
			, esc_html__('Forms', 'leform')
			, $cap
			, "leform"
			, array(&$this, 'admin_forms')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Create Form', 'leform')
			, esc_html__('Create Form', 'leform')
			, $cap
			, "leform-add"
			, array(&$this, 'admin_add_form')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Log', 'leform')
			, esc_html__('Log', 'leform')
			, $cap
			, "leform-log"
			, array(&$this, 'admin_records')
		);
		if ($leform->advanced_options['admin-menu-stats'] != 'off') {
			add_submenu_page(
				"leform"
				, esc_html__('Stats', 'leform')
				, esc_html__('Stats', 'leform')
				, $cap
				, "leform-stats"
				, array(&$this, 'admin_stats')
			);
		}
		if ($leform->advanced_options['admin-menu-analytics'] != 'off') {
			add_submenu_page(
				"leform"
				, esc_html__('Field Analytics', 'leform')
				, esc_html__('Field Analytics', 'leform')
				, $cap
				, "leform-field-analytics"
				, array(&$this, 'admin_field_analytics')
			);
		}
		if ($leform->advanced_options['admin-menu-transactions'] != 'off') {
			add_submenu_page(
				"leform"
				, esc_html__('Transactions', 'leform')
				, esc_html__('Transactions', 'leform')
				, $cap
				, "leform-transactions"
				, array(&$this, 'admin_transactions')
			);
		}
		do_action('leform_admin_menu');
		add_submenu_page(
			"leform"
			, esc_html__('Settings', 'leform')
			, esc_html__('Settings', 'leform')
			, $cap
			, "leform-settings"
			, array(&$this, 'admin_settings')
		);
		if (defined('UAP_CORE')) {
			add_submenu_page(
				"leform"
				, esc_html__('How To Use', 'leform')
				, esc_html__('How To Use', 'leform')
				, $cap
				, "leform-using"
				, array(&$this, 'admin_using')
			);
		}
	}

	function admin_using() {
		global $wpdb, $leform;
		echo '
		<div class="wrap leform-admin leform">
			<h2>'.esc_html__('Green Forms - How To Use', 'leform').'
				<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
			</h2>
			<div class="leform-settings leform-using-page">
				<h3>'.esc_html__('Embedding Green Forms', 'leform').'</h3>
				<p>'.esc_html__('To embed Green Forms into any website you need perform the following steps:', 'leform').'</p>
				<ol>
					<li>
						<span>'.sprintf(esc_html__('Make sure that website has %sDOCTYPE%s. If not, add the following line as a first line of HTML-document:', 'leform'), '<code>', '</code>').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<!DOCTYPE html>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.sprintf(esc_html__('Make sure that website loads jQuery version 1.9 or higher. If not, add the following line into %shead%s section of HTML-document:', 'leform'), '<code>', '</code>').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.sprintf(esc_html__('Copy the following JS-snippet and paste it into website code. You need paste it at the end of %sbody%s section (above closing %s</body>%s tag).', 'leform'), '<code>', '</code>', '<code>', '</code>').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<script id="leform-remote" src="'.$leform->plugins_url.'/js/leform'.($leform->advanced_options['minified-sources'] == 'on' ? '.min' : '').'.js?ver='.LEFORM_VERSION.'" data-handler="'.admin_url('admin-ajax.php').'"></script>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.esc_html__('Integration finished!', 'leform').'</span>
					</li>
				</ol>
			</div>
			<div class="leform-settings leform-using-page">
				<h3>'.esc_html__('Using Green Forms', 'leform').'</h3>
				<p>'.esc_html__('You can insert forms as regular inline forms or/and raise them as popups.', 'leform').'</p>
				<ol>
					<li>
						<span>'.esc_html__('Use the following HTML-code to embed the form into HTML-document as inline form:', 'leform').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<div class="leform-inline" data-id="{FORM-ID}"></div>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.esc_html__('Use the following URL with a link/button (href attribute) to open the form in popup mode:', 'leform').'</span>
						<input type="text" readonly="readonly" value="#leformx-{FORM-ID}" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.esc_html__('Use the following javascript function to open the form in popup mode:', 'leform').'</span>
						<input type="text" readonly="readonly" value="leform_popup_open({FORM-ID});" onclick="this.focus();this.select();" />
					</li>
				</ol>
				<p>'.sprintf(esc_html__('Replace {FORM-ID} by real Form ID. You can find Form ID by clicking %s icon on %sForms%s page.', 'leform'), '<i class="fas fa-code" style="font-size: 20px;"></i>', '<a href="?page=leform">', '</a>').'</p>
			</div>
		</div>';
	}
	
	function admin_settings() {
		global $wpdb, $leform;
		if (isset($_GET['subpage']) && $_GET['subpage'] == 'advanced') {
			$this->admin_advanced_settings();
			return;
		}
		echo '
<div class="wrap leform-admin leform">
	<h2>'.esc_html__('Green Forms - General Settings', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
	<div class="leform-tabs leform-tabs-main">
		<a class="leform-tab leform-tab-active" href="'.admin_url('admin.php').'?page=leform-settings">'.esc_html__('General', 'leform').'</a>
		<a class="leform-tab" href="'.admin_url('admin.php').'?page=leform-settings&subpage=advanced">'.esc_html__('Advanced', 'leform').'</a>
	</div>
	<form class="leform-settings-form" enctype="multipart/form-data" method="post" style="margin: 0px" action="'.admin_url('admin.php').'">
		<div class="leform-settings" style="position: relative;">
			<h3>'.esc_html__('Mailing Settings', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Sender name', 'leform').':</th>
					<td>
						<input type="text" id="leform-from-name" name="leform-from-name" value="'.esc_html($leform->options['from-name']).'" class="widefat" />
						<br /><em>'.esc_html__('Please enter sender name. All messages from plugin are sent using this name as "FROM:" header value.', 'leform').'</a></em>.
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Sender email', 'leform').':</th>
					<td>
						<input type="text" id="leform-from-email" name="leform-from-email" value="'.esc_html($leform->options['from-email']).'" class="widefat" />
						<br /><em>'.esc_html__('Please enter sender e-mail. All messages from plugin are sent using this e-mail as "FROM:" header value.', 'leform').'</a></em>.
					</td>
				</tr>
			</table>
			<h3>'.esc_html__('Miscellaneous', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('GA tracking', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-ga-tracking" name="leform-ga-tracking" value="on" '.($leform->options['ga-tracking'] == "on" ? 'checked="checked"' : '').' /><label for="leform-ga-tracking"></label><span>'.esc_html__('Enable Google Analytics tracking', 'leform').'</span>
						<br /><em>'.esc_html__('Send form submission event to Google Analytics. GA must be installed on your website. If you use GTM, please configure it properly to accept events.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Font Awesome', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-fa-enable" name="leform-fa-enable" value="on" '.($leform->options['fa-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-fa-enable\').is(\':checked\')){jQuery(\'.leform-fa-extra\').fadeIn(300);}else{jQuery(\'.leform-fa-extra\').fadeOut(300);}" /><label for="leform-fa-enable"></label><span>'.esc_html__('Enable Font Awesome icons', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use full set of Font Awesome icons.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-solid-enable" name="leform-fa-solid-enable" value="on" '.($leform->options['fa-solid-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-solid-enable"></label><span>'.esc_html__('Enable Solid Icons', 'leform').'</span>
						<br /><em>'.esc_html__('Enable Font Awesome Solid Icons, you can turn it off you do not need Solid Icons pack. More details:', 'leform').' <a href="https://fontawesome.com/cheatsheet" target="_blank">https://fontawesome.com/cheatsheet</a>.</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-regular-enable" name="leform-fa-regular-enable" value="on" '.($leform->options['fa-regular-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-regular-enable"></label><span>'.esc_html__('Enable Regular Icons', 'leform').'</span>
						<br /><em>'.esc_html__('Enable Font Awesome Regular Icons, you can turn it off you do not need Regular Icons pack. More details:', 'leform').' <a href="https://fontawesome.com/cheatsheet" target="_blank">https://fontawesome.com/cheatsheet</a>.</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-brands-enable" name="leform-fa-brands-enable" value="on" '.($leform->options['fa-brands-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-brands-enable"></label><span>'.esc_html__('Enable Brand Icons', 'leform').'</span>
						<br /><em>'.esc_html__('Enable Font Awesome Brand Icons, you can turn it off you do not need Brand Icons pack. More details:', 'leform').' <a href="https://fontawesome.com/cheatsheet" target="_blank">https://fontawesome.com/cheatsheet</a>.</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-css-disable" name="leform-fa-css-disable" value="on" '.($leform->options['fa-css-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-css-disable"></label><span>'.esc_html__('Do not load Font Awesome library', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Font Awesome library.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Air Datepicker plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-airdatepicker-enable" name="leform-airdatepicker-enable" value="on" '.($leform->options['airdatepicker-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-airdatepicker-enable\').is(\':checked\')){jQuery(\'.leform-airdatepicker-extra\').fadeIn(300);}else{jQuery(\'.leform-airdatepicker-extra\').fadeOut(300);}" /><label for="leform-airdatepicker-enable"></label><span>'.esc_html__('Enable Air Datepicker plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use nice datepicker with forms.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-airdatepicker-extra"'.($leform->options['airdatepicker-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-airdatepicker-js-disable" name="leform-airdatepicker-js-disable" value="on" '.($leform->options['airdatepicker-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-airdatepicker-js-disable"></label><span>'.esc_html__('Do not load Air Datepicker plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Air Datepicker plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('jQuery Mask plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-mask-enable" name="leform-mask-enable" value="on" '.($leform->options['mask-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-mask-enable\').is(\':checked\')){jQuery(\'.leform-mask-extra\').fadeIn(300);}else{jQuery(\'.leform-mask-extra\').fadeOut(300);}" /><label for="leform-mask-enable"></label><span>'.esc_html__('Enable jQuery Mask plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to specify input masks for text fields.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-mask-extra"'.($leform->options['mask-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-mask-js-disable" name="leform-mask-js-disable" value="on" '.($leform->options['mask-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-mask-js-disable"></label><span>'.esc_html__('Do not load jQuery Mask plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads jQuery Mask plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('JavaScript Expression Parser', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-jsep-enable" name="leform-jsep-enable" value="on" '.($leform->options['jsep-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-jsep-enable\').is(\':checked\')){jQuery(\'.leform-jsep-extra\').fadeIn(300);}else{jQuery(\'.leform-jsep-extra\').fadeOut(300);}" /><label for="leform-jsep-enable"></label><span>'.esc_html__('Enable JavaScript Expression Parser plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use math expressions and show results on front-end side.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-jsep-extra"'.($leform->options['jsep-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-jsep-js-disable" name="leform-jsep-js-disable" value="on" '.($leform->options['jsep-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-jsep-js-disable"></label><span>'.esc_html__('Do not load JavaScript Expression Parser plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads JavaScript Expression Parser plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Signature Pad plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-signature-enable" name="leform-signature-enable" value="on" '.($leform->options['signature-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(this).is(\':checked\')){jQuery(\'.leform-signature-extra\').fadeIn(300);}else{jQuery(\'.leform-signature-extra\').fadeOut(300);}" /><label for="leform-signature-enable"></label><span>'.esc_html__('Enable Signature Pad plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use signature pad with forms.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-signature-extra"'.($leform->options['signature-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-signature-js-disable" name="leform-signature-js-disable" value="on" '.($leform->options['signature-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-signature-js-disable"></label><span>'.esc_html__('Do not load Signature Pad plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Signature Pad plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Ion.RangeSlider plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-range-slider-enable" name="leform-range-slider-enable" value="on" '.($leform->options['range-slider-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(this).is(\':checked\')){jQuery(\'.leform-range-slider-extra\').fadeIn(300);}else{jQuery(\'.leform-range-slider-extra\').fadeOut(300);}" /><label for="leform-range-slider-enable"></label><span>'.esc_html__('Enable Ion.RangeSlider plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use range slider with forms.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-range-slider-extra"'.($leform->options['range-slider-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-range-slider-js-disable" name="leform-range-slider-js-disable" value="on" '.($leform->options['range-slider-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-range-slider-js-disable"></label><span>'.esc_html__('Do not load Ion.RangeSlider plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Ion.RangeSlider plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Tooltipster plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-tooltipster-enable" name="leform-tooltipster-enable" value="on" '.($leform->options['tooltipster-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(this).is(\':checked\')){jQuery(\'.leform-tooltipster-extra\').fadeIn(300);}else{jQuery(\'.leform-tooltipster-extra\').fadeOut(300);}" /><label for="leform-tooltipster-enable"></label><span>'.esc_html__('Enable Tooltipster plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use nice tooltips with your form (driven by Tooltipster).', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-tooltipster-extra"'.($leform->options['tooltipster-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-tooltipster-js-disable" name="leform-tooltipster-js-disable" value="on" '.($leform->options['tooltipster-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-tooltipster-js-disable"></label><span>'.esc_html__('Do not load Tooltipster plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Tooltipster plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('CSV column separator', 'leform').':</th>
					<td>
						<select id="leform-csv-separator" name="leform-csv-separator">
							<option value=";"'.($leform->options['csv-separator'] == ';' ? ' selected="selected"' : '').'>'.esc_html__('Semicolon - ";"', 'leform').'</option>
							<option value=","'.($leform->options['csv-separator'] == ',' ? ' selected="selected"' : '').'>'.esc_html__('Comma - ","', 'leform').'</option>
							<option value="tab"'.($leform->options['csv-separator'] == 'tab' ? ' selected="selected"' : '').'>'.esc_html__('Tab', 'leform').'</option>
						</select>
						<br /><em>'.esc_html__('Please select CSV column separator.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Email validation', 'leform').':</th>
					<td>
						<select id="leform-email-validator" name="leform-email-validator" onchange="leform_email_validator_changed(this);">';
			foreach ($leform->email_validators as $key => $label) {
				echo '<option value="'.esc_html($key).'"'.($leform->options['email-validator'] == $key ? ' selected="selected"' : '').'>'.esc_html($label).'</option>';
			}
			echo '
						</select>
						<br /><em>'.esc_html__('Please select the type of email validation.', 'leform').'</em>
					</td>
				</tr>';
			do_action('leform_email_validator_options_show', $leform->options['email-validator']);
			echo '
				<tr>
					<th>'.esc_html__('User uploads', 'leform').':</th>
					<td>
						<select id="leform-file-autodelete" name="leform-file-autodelete">';
			foreach ($leform->file_autodelete_options as $key => $label) {
				echo '<option value="'.esc_html($key).'"'.($leform->options['file-autodelete'] == $key ? ' selected="selected"' : '').'>'.esc_html($label).'</option>';
			}
			echo '
						</select>
						<br /><em>'.esc_html__('Please select how long to keep user uploads on server.', 'leform').'</em>
					</td>
				</tr>';
			echo '
			</table>';
		do_action('leform_options_show');
		echo '
			<h3>'.esc_html__('Item Purchase Code', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Item Purchase Code', 'leform').':</th>
					<td>
						<input type="text" id="leform-purchase-code" name="leform-purchase-code" value="'.esc_html($leform->options['purchase-code']).'" class="widefat" />
						<br /><em>'.esc_html__('To activate your license please enter Item Purchase Code.', 'leform').' <a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600">'.esc_html__('Where can I find my Purchase Code?', 'leform').'</a></em>
					</td>
				</tr>
			</table>
			<hr>
			<div class="leform-button-container">
				<input type="hidden" name="action" value="leform-settings-save" />
				<a class="leform-button" onclick="return leform_settings_save(this);"><i class="fas fa-check"></i><label>'.esc_html__('Save Settings', 'leform').'</label></a>
			</div>
		</div>
	</form>
</div>
<div id="leform-global-message"></div>';
		
	}

	function admin_advanced_settings() {
		global $wpdb, $leform;
		
		if (!in_array('curl', get_loaded_extensions())) {
			$is_curl = false;
			$message .= '<div class="error"><p>'.esc_html__('cURL is not installed! Some modules are not available.', 'leform').'</p></div>';
		
		} else $is_curl = true;
		echo '
<div class="wrap leform-admin leform">
	<h2>'.esc_html__('Green Forms - Advanced Settings', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
	<div class="leform-tabs leform-tabs-main">
		<a class="leform-tab" href="'.admin_url('admin.php').'?page=leform-settings">'.esc_html__('General', 'leform').'</a>
		<a class="leform-tab leform-tab-active" href="'.admin_url('admin.php').'?page=leform-settings&subpage=advanced">'.esc_html__('Advanced', 'leform').'</a>
	</div>
	<form class="leform-settings-form" enctype="multipart/form-data" method="post" style="margin: 0px" action="'.admin_url('admin.php').'">
		<div class="leform-settings" style="position: relative;">
			<h3>'.esc_html__('Plugin Modules', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Basic', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-custom-js" name="leform-advanced-enable-custom-js" value="on" '.($leform->advanced_options['enable-custom-js'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-custom-js"></label><span>'.esc_html__('Activate Custom JavaScript Handlers module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to use custom javascript event handlers for forms. Configure them on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-htmlform" name="leform-advanced-enable-htmlform" value="on" '.($leform->advanced_options['enable-htmlform'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-htmlform"></label><span>'.esc_html__('Activate HTML Form Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to re-submit form data as a part of 3rd party HTML form. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-post" name="leform-advanced-enable-post" value="on" '.($leform->advanced_options['enable-post'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-post"></label><span>'.esc_html__('Activate Custom GET/POST Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to re-submit form data to 3rd party URL using GET or POST request. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mysql" name="leform-advanced-enable-mysql" value="on" '.($leform->advanced_options['enable-mysql'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mysql"></label><span>'.esc_html__('Activate 3rd party MySQL Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to insert form data into 3rd party MySQL table. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-wpuser" name="leform-advanced-enable-wpuser" value="on" '.($leform->advanced_options['enable-wpuser'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-wpuser"></label><span>'.esc_html__('Activate WP User Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to create new WordPress user when form submitted. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr><td colspan="2"><hr /></td></tr>
				<tr>
					<th>'.esc_html__('Marketing Systems, Newsletters and CRM', 'leform').':</th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-acellemail" name="leform-advanced-enable-acellemail" value="on" '.($leform->advanced_options['enable-acellemail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-acellemail"></label><span>'.esc_html__('Activate Acelle Mail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Acelle Mail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-activecampaign" name="leform-advanced-enable-activecampaign" value="on" '.($leform->advanced_options['enable-activecampaign'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-activecampaign"></label><span>'.esc_html__('Activate ActiveCampaign Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to ActiveCampaign. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-activetrail" name="leform-advanced-enable-activetrail" value="on" '.($leform->advanced_options['enable-activetrail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-activetrail"></label><span>'.esc_html__('Activate ActiveTrail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to ActiveTrail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-agilecrm" name="leform-advanced-enable-agilecrm" value="on" '.($leform->advanced_options['enable-agilecrm'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-agilecrm"></label><span>'.esc_html__('Activate AgileCRM Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to AgileCRM. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-automizy" name="leform-advanced-enable-automizy" value="on" '.($leform->advanced_options['enable-automizy'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-automizy"></label><span>'.esc_html__('Activate Automizy Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Automizy. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-avangemail" name="leform-advanced-enable-avangemail" value="on" '.($leform->advanced_options['enable-avangemail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-avangemail"></label><span>'.esc_html__('Activate AvangEmail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to AvangEmail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-aweber" name="leform-advanced-enable-aweber" value="on" '.($leform->advanced_options['enable-aweber'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-aweber"></label><span>'.esc_html__('Activate AWeber Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to AWeber. Connect to AWeber on General Settings page and configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-birdsend" name="leform-advanced-enable-birdsend" value="on" '.($leform->advanced_options['enable-birdsend'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-birdsend"></label><span>'.esc_html__('Activate BirdSend Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to BirdSend. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-bitrix24" name="leform-advanced-enable-bitrix24" value="on" '.($leform->advanced_options['enable-bitrix24'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-bitrix24"></label><span>'.esc_html__('Activate Bitrix24 Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Bitrix24. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-campaignmonitor" name="leform-advanced-enable-campaignmonitor" value="on" '.($leform->advanced_options['enable-campaignmonitor'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-campaignmonitor"></label><span>'.esc_html__('Activate Campaign Monitor Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Campaign Monitor. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-cleverreach" name="leform-advanced-enable-cleverreach" value="on" '.($leform->advanced_options['enable-cleverreach'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-cleverreach"></label><span>'.esc_html__('Activate CleverReach Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to CleverReach. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-constantcontact" name="leform-advanced-enable-constantcontact" value="on" '.($leform->advanced_options['enable-constantcontact'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-constantcontact"></label><span>'.esc_html__('Activate Constant Contact Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Constant Contact. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-conversio" name="leform-advanced-enable-conversio" value="on" '.($leform->advanced_options['enable-conversio'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-conversio"></label><span>'.esc_html__('Activate Conversio Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Conversio. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-drip" name="leform-advanced-enable-drip" value="on" '.($leform->advanced_options['enable-drip'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-drip"></label><span>'.esc_html__('Activate Drip Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Drip. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-fluentcrm" name="leform-advanced-enable-fluentcrm" value="on" '.($leform->advanced_options['enable-fluentcrm'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-fluentcrm"></label><span>'.esc_html__('Activate FluentCRM Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to FluentCRM. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-freshmail" name="leform-advanced-enable-freshmail" value="on" '.($leform->advanced_options['enable-freshmail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-freshmail"></label><span>'.esc_html__('Activate FreshMail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to FreshMail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-getresponse" name="leform-advanced-enable-getresponse" value="on" '.($leform->advanced_options['enable-getresponse'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-getresponse"></label><span>'.esc_html__('Activate GetResponse Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to GetResponse. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-hubspot" name="leform-advanced-enable-hubspot" value="on" '.($leform->advanced_options['enable-hubspot'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-hubspot"></label><span>'.esc_html__('Activate HubSpot Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to HubSpot. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-inbox" name="leform-advanced-enable-inbox" value="on" '.($leform->advanced_options['enable-inbox'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-inbox"></label><span>'.esc_html__('Activate INBOX Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to INBOX. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-jetpack" name="leform-advanced-enable-jetpack" value="on" '.($leform->advanced_options['enable-jetpack'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-jetpack"></label><span>'.esc_html__('Activate Jetpack Subscriptions Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Jetpack Subscriptions. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-klaviyo" name="leform-advanced-enable-klaviyo" value="on" '.($leform->advanced_options['enable-klaviyo'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-klaviyo"></label><span>'.esc_html__('Activate Klaviyo Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Klaviyo. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-madmimi" name="leform-advanced-enable-madmimi" value="on" '.($leform->advanced_options['enable-madmimi'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-madmimi"></label><span>'.esc_html__('Activate Mad Mimi Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mad Mimi. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailautic" name="leform-advanced-enable-mailautic" value="on" '.($leform->advanced_options['enable-mailautic'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailautic"></label><span>'.esc_html__('Activate Mailautic Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mailautic. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailchimp" name="leform-advanced-enable-mailchimp" value="on" '.($leform->advanced_options['enable-mailchimp'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailchimp"></label><span>'.esc_html__('Activate MailChimp Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailChimp. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailerlite" name="leform-advanced-enable-mailerlite" value="on" '.($leform->advanced_options['enable-mailerlite'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailerlite"></label><span>'.esc_html__('Activate MailerLite Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailerLite. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailfit" name="leform-advanced-enable-mailfit" value="on" '.($leform->advanced_options['enable-mailfit'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailfit"></label><span>'.esc_html__('Activate MailFit Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailFit. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailgun" name="leform-advanced-enable-mailgun" value="on" '.($leform->advanced_options['enable-mailgun'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailgun"></label><span>'.esc_html__('Activate Mailgun Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mailgun. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailjet" name="leform-advanced-enable-mailjet" value="on" '.($leform->advanced_options['enable-mailjet'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailjet"></label><span>'.esc_html__('Activate Mailjet Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mailjet. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-mailpoet" name="leform-advanced-enable-mailpoet" value="on" '.($leform->advanced_options['enable-mailpoet'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailpoet"></label><span>'.esc_html__('Activate MailPoet Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailPoet. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-mailster" name="leform-advanced-enable-mailster" value="on" '.($leform->advanced_options['enable-mailster'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailster"></label><span>'.esc_html__('Activate Mailster Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mailster. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailwizz" name="leform-advanced-enable-mailwizz" value="on" '.($leform->advanced_options['enable-mailwizz'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailwizz"></label><span>'.esc_html__('Activate MailWizz Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailWizz. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mautic" name="leform-advanced-enable-mautic" value="on" '.($leform->advanced_options['enable-mautic'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mautic"></label><span>'.esc_html__('Activate Mautic Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mautic. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-moosend" name="leform-advanced-enable-moosend" value="on" '.($leform->advanced_options['enable-moosend'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-moosend"></label><span>'.esc_html__('Activate Moosend Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Moosend. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mumara" name="leform-advanced-enable-mumara" value="on" '.($leform->advanced_options['enable-mumara'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mumara"></label><span>'.esc_html__('Activate Mumara Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mumara. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-omnisend" name="leform-advanced-enable-omnisend" value="on" '.($leform->advanced_options['enable-omnisend'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-omnisend"></label><span>'.esc_html__('Activate Omnisend Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Omnisend. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-ontraport" name="leform-advanced-enable-ontraport" value="on" '.($leform->advanced_options['enable-ontraport'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-ontraport"></label><span>'.esc_html__('Activate Ontraport Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Ontraport. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-rapidmail" name="leform-advanced-enable-rapidmail" value="on" '.($leform->advanced_options['enable-rapidmail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-rapidmail"></label><span>'.esc_html__('Activate Rapidmail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Rapidmail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-salesautopilot" name="leform-advanced-enable-salesautopilot" value="on" '.($leform->advanced_options['enable-salesautopilot'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-salesautopilot"></label><span>'.esc_html__('Activate SalesAutoPilot Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to SalesAutoPilot. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-sendfox" name="leform-advanced-enable-sendfox" value="on" '.($leform->advanced_options['enable-sendfox'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-sendfox"></label><span>'.esc_html__('Activate SendFox Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to SendFox. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-sendgrid" name="leform-advanced-enable-sendgrid" value="on" '.($leform->advanced_options['enable-sendgrid'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-sendgrid"></label><span>'.esc_html__('Activate SendGrid Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to SendGrid. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-sendinblue" name="leform-advanced-enable-sendinblue" value="on" '.($leform->advanced_options['enable-sendinblue'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-sendinblue"></label><span>'.esc_html__('Activate SendinBlue Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to SendinBlue. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-sendpulse" name="leform-advanced-enable-sendpulse" value="on" '.($leform->advanced_options['enable-sendpulse'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-sendpulse"></label><span>'.esc_html__('Activate SendPulse Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to SendPulse. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-sendy" name="leform-advanced-enable-sendy" value="on" '.($leform->advanced_options['enable-sendy'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-sendy"></label><span>'.esc_html__('Activate Sendy Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Sendy. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-thenewsletterplugin" name="leform-advanced-enable-thenewsletterplugin" value="on" '.($leform->advanced_options['enable-thenewsletterplugin'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-thenewsletterplugin"></label><span>'.esc_html__('Activate The Newsletter Plugin Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to The Newsletter Plugin. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-tribulant" name="leform-advanced-enable-tribulant" value="on" '.($leform->advanced_options['enable-tribulant'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-tribulant"></label><span>'.esc_html__('Activate Tribulant Newsletters Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Tribulant Newsletters. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-ymlp" name="leform-advanced-enable-ymlp" value="on" '.($leform->advanced_options['enable-ymlp'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-ymlp"></label><span>'.esc_html__('Activate Your Mailing List Provider Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Your Mailing List Provider. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-zapier" name="leform-advanced-enable-zapier" value="on" '.($leform->advanced_options['enable-zapier'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-zapier"></label><span>'.esc_html__('Activate Zapier Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Zapier. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-zohocrm" name="leform-advanced-enable-zohocrm" value="on" '.($leform->advanced_options['enable-zohocrm'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-zohocrm"></label><span>'.esc_html__('Activate Zoho CRM Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Zoho CRM. Connect to Zoho CRM on General Settings page and configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr><td colspan="2"><hr /></td></tr>
				<tr>
					<th>'.esc_html__('Payment Providers', 'leform').':</th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-authorizenet" name="leform-advanced-enable-authorizenet" value="on" '.($leform->advanced_options['enable-authorizenet'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-authorizenet"></label><span>'.esc_html__('Activate Authorize.Net Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Authorize.Net. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-blockchain" name="leform-advanced-enable-blockchain" value="on" '.($leform->advanced_options['enable-blockchain'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-blockchain"></label><span>'.esc_html__('Activate Blockchain Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Blockchain. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-instamojo" name="leform-advanced-enable-instamojo" value="on" '.($leform->advanced_options['enable-instamojo'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-instamojo"></label><span>'.esc_html__('Activate Instamojo Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Instamojo. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-interkassa" name="leform-advanced-enable-interkassa" value="on" '.($leform->advanced_options['enable-interkassa'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-interkassa"></label><span>'.esc_html__('Activate InterKassa Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via InterKassa. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mollie" name="leform-advanced-enable-mollie" value="on" '.($leform->advanced_options['enable-mollie'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mollie"></label><span>'.esc_html__('Activate Mollie Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Mollie. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-payfast" name="leform-advanced-enable-payfast" value="on" '.($leform->advanced_options['enable-payfast'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-payfast"></label><span>'.esc_html__('Activate PayFast Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via PayFast. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-paypal" name="leform-advanced-enable-paypal" value="on" '.($leform->advanced_options['enable-paypal'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-paypal"></label><span>'.esc_html__('Activate PayPal Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via PayPal. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-paystack" name="leform-advanced-enable-paystack" value="on" '.($leform->advanced_options['enable-paystack'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-paystack"></label><span>'.esc_html__('Activate Paystack Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Paystack (accept NGN only). Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-payumoney" name="leform-advanced-enable-payumoney" value="on" '.($leform->advanced_options['enable-payumoney'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-payumoney"></label><span>'.esc_html__('Activate PayUmoney Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via PayUmoney. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-perfectmoney" name="leform-advanced-enable-perfectmoney" value="on" '.($leform->advanced_options['enable-perfectmoney'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-perfectmoney"></label><span>'.esc_html__('Activate Perfect Money Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Perfect Money. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-razorpay" name="leform-advanced-enable-razorpay" value="on" '.($leform->advanced_options['enable-razorpay'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-razorpay"></label><span>'.esc_html__('Activate Razorpay Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Razorpay. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-skrill" name="leform-advanced-enable-skrill" value="on" '.($leform->advanced_options['enable-skrill'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-skrill"></label><span>'.esc_html__('Activate Skrill Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Skrill. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-stripe" name="leform-advanced-enable-stripe" value="on" '.($leform->advanced_options['enable-stripe'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-stripe"></label><span>'.esc_html__('Activate Stripe Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Stripe. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-wepay" name="leform-advanced-enable-wepay" value="on" '.($leform->advanced_options['enable-wepay'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-wepay"></label><span>'.esc_html__('Activate WePay Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via WePay. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-yandexmoney" name="leform-advanced-enable-yandexmoney" value="on" '.($leform->advanced_options['enable-yandexmoney'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-yandexmoney"></label><span>'.esc_html__('Activate Yandex.Money Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Yandex.Money. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr><td colspan="2"><hr /></td></tr>
				<tr>
					<th>'.esc_html__('SMS Gateways', 'leform').':</th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-bulkgate" name="leform-advanced-enable-bulkgate" value="on" '.($leform->advanced_options['enable-bulkgate'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-bulkgate"></label><span>'.esc_html__('Activate BulkGate Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to use BulkGate gateway. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-gatewayapi" name="leform-advanced-enable-gatewayapi" value="on" '.($leform->advanced_options['enable-gatewayapi'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-gatewayapi"></label><span>'.esc_html__('Activate GatewayAPI Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to use GatewayAPI gateway. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-nexmo" name="leform-advanced-enable-nexmo" value="on" '.($leform->advanced_options['enable-nexmo'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-nexmo"></label><span>'.esc_html__('Activate Nexmo Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to use Nexmo gateway. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-twilio" name="leform-advanced-enable-twilio" value="on" '.($leform->advanced_options['enable-twilio'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-twilio"></label><span>'.esc_html__('Activate Twilio Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to use Twilio gateway. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
			</table>
			<table class="leform-useroptions">
				<tr><td colspan="2"><hr /></td></tr>
				<tr>
					<th>'.esc_html__('Extended email validation', 'leform').':</th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-clearout" name="leform-advanced-enable-clearout" value="on" '.($leform->advanced_options['enable-clearout'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-clearout"></label><span>'.esc_html__('Activate Clearout Integration module', 'leform').'</span>
						<br /><em>'.sprintf(esc_html__('Turn this module on if you want to use %sClearout%s to validate email addresses. Configure integration on General Settings page.', 'leform'), '<a href="https://clearout.io/" target="_blank">', '</a>').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-kickbox" name="leform-advanced-enable-kickbox" value="on" '.($leform->advanced_options['enable-kickbox'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-kickbox"></label><span>'.esc_html__('Activate Kickbox Integration module', 'leform').'</span>
						<br /><em>'.sprintf(esc_html__('Turn this module on if you want to use %sKickbox%s to validate email addresses. Configure integration on General Settings page.', 'leform'), '<a href="https://kickbox.com/" target="_blank">', '</a>').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-thechecker" name="leform-advanced-enable-thechecker" value="on" '.($leform->advanced_options['enable-thechecker'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-thechecker"></label><span>'.esc_html__('Activate TheChecker Integration module', 'leform').'</span>
						<br /><em>'.sprintf(esc_html__('Turn this module on if you want to use %sTheChecker%s to validate email addresses. Configure integration on General Settings page.', 'leform'), '<a href="https://thechecker.co/" target="_blank">', '</a>').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-truemail" name="leform-advanced-enable-truemail" value="on" '.($leform->advanced_options['enable-truemail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-truemail"></label><span>'.esc_html__('Activate TrueMail Integration module', 'leform').'</span>
						<br /><em>'.sprintf(esc_html__('Turn this module on if you want to use %sTrueMail%s to validate email addresses. Configure integration on General Settings page.', 'leform'), '<a href="https://truemail.io/" target="_blank">', '</a>').'</em>
					</td>
				</tr>
			</table>
			<h3>'.esc_html__('Translations', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Detail labels', 'leform').':</th>
					<td>
						<input type="text" id="leform-advanced-label-form-values" name="leform-advanced-label-form-values" value="'.esc_html($leform->advanced_options['label-form-values']).'" class="widefat" />
						<br /><em>'.esc_html__('Form Values', 'leform').'</a></em>.
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="text" id="leform-advanced-label-payment" name="leform-advanced-label-payment" value="'.esc_html($leform->advanced_options['label-payment']).'" class="widefat" />
						<br /><em>'.esc_html__('Payment', 'leform').'</a></em>.
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="text" id="leform-advanced-label-general-info" name="leform-advanced-label-general-info" value="'.esc_html($leform->advanced_options['label-general-info']).'" class="widefat" />
						<br /><em>'.esc_html__('General Info', 'leform').'</a></em>.
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="text" id="leform-advanced-label-raw-details" name="leform-advanced-label-raw-details" value="'.esc_html($leform->advanced_options['label-raw-details']).'" class="widefat" />
						<br /><em>'.esc_html__('Raw Details', 'leform').'</a></em>.
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="text" id="leform-advanced-label-technical-info" name="leform-advanced-label-technical-info" value="'.esc_html($leform->advanced_options['label-technical-info']).'" class="widefat" />
						<br /><em>'.esc_html__('Technical Info', 'leform').'</a></em>.
					</td>
				</tr>
			</table>
			<h3>'.esc_html__('Miscellaneous', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Custom fonts', 'leform').':</th>
					<td>
						<textarea id="leform-advanced-custom-fonts" name="leform-advanced-custom-fonts" class="widefat">'.esc_html($leform->advanced_options['custom-fonts']).'</textarea>
						<br /><em>'.esc_html__('If your theme uses custom fonts, paste font name (as it is defined in CSS-file) here. One font name per line.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Admin menu items', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-advanced-admin-menu-stats" name="leform-advanced-admin-menu-stats" value="on" '.($leform->advanced_options['admin-menu-stats'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-admin-menu-stats"></label><span>'.esc_html__('Enable "Stats" menu item', 'leform').'</span>
						<br /><em>'.esc_html__('Show or hide menu item "Stats" in Left Side admin menu.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-admin-menu-analytics" name="leform-advanced-admin-menu-analytics" value="on" '.($leform->advanced_options['admin-menu-analytics'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-admin-menu-analytics"></label><span>'.esc_html__('Enable "Field Analytics" menu item', 'leform').'</span>
						<br /><em>'.esc_html__('Show or hide menu item "Field Analytics" in Left Side admin menu.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-admin-menu-transactions" name="leform-advanced-admin-menu-transactions" value="on" '.($leform->advanced_options['admin-menu-transactions'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-admin-menu-transactions"></label><span>'.esc_html__('Enable "Transactions" menu item', 'leform').'</span>
						<br /><em>'.esc_html__('Show or hide menu item "Transactions" in Left Side admin menu.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('!Important CSS', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-advanced-important-enable" name="leform-advanced-important-enable" value="on" '.($leform->advanced_options['important-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-important-enable"></label><span>'.esc_html__('Add suffix "!important" to styles.', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on of you have some CSS-conflicts with existing stylesheet.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Minification', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-advanced-minified-sources" name="leform-advanced-minified-sources" value="on" '.($leform->advanced_options['minified-sources'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-minified-sources"></label><span>'.esc_html__('Use minified JS and CSS files', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on to use minified JS and CSS files.', 'leform').'</em>
					</td>
				</tr>
			</table>
			<hr>
			<div class="leform-button-container">
				<input type="hidden" name="action" value="leform-advanced-settings-save" />
				<a class="leform-button" onclick="return leform_settings_save(this);"><i class="fas fa-check"></i><label>'.esc_html__('Save Settings', 'leform').'</label></a>
			</div>
		</div>
	</form>
</div>
<div id="leform-global-message"></div>';
	}

	function admin_forms() {
		global $wpdb, $leform;
		
		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		
		$tmp = $wpdb->get_row("SELECT COUNT(*) AS total FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0'".((strlen($search_query) > 0) ? " AND name LIKE '%".esc_sql($wpdb->esc_like($search_query))."%'" : ""), ARRAY_A);
		$total = $tmp["total"];
		$totalpages = ceil($total/LEFORM_RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = $leform->page_switcher(admin_url('admin.php').'?page=leform'.((strlen($search_query) > 0) ? '&s='.rawurlencode($search_query) : ''), $page, $totalpages);

		if (isset($_GET['o'])) {
			$sort = $_GET['o'];
			if (in_array($sort, $leform->sort_methods)) {
				if ($sort != $leform->options['sort-forms']) {
					update_option('leform-sort-forms', $sort);
					$leform->options['sort-forms'] = $sort;
				}
			} else $sort = $leform->options['sort-forms'];
		} else $sort = $leform->options['sort-forms'];
		$orderby = 't1.created DESC';
		switch ($sort) {
			case 'name-az':
				$orderby = 't1.name ASC';
				break;
			case 'name-za':
				$orderby = 't1.name DESC';
				break;
			case 'date-az':
				$orderby = 't1.created ASC';
				break;
			default:
				$orderby = 't1.created DESC';
				break;
		}
		
		$sql = "SELECT t1.*, t2.entries FROM ".$wpdb->prefix."leform_forms t1 LEFT JOIN (SELECT COUNT(*) AS entries, form_id FROM ".$wpdb->prefix."leform_records WHERE deleted = '0' GROUP BY form_id) t2 ON t2.form_id = t1.id WHERE t1.deleted = '0'".((strlen($search_query) > 0) ? " AND t1.name LIKE '%".esc_sql($wpdb->esc_like($search_query))."%'" : "")." ORDER BY ".$orderby." LIMIT ".esc_sql(($page-1)*LEFORM_RECORDS_PER_PAGE).", ".esc_sql(LEFORM_RECORDS_PER_PAGE);
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		$upload_dir = wp_upload_dir();
		if (!class_exists('ZipArchive') || !class_exists('DOMDocument') || !file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp')) $export_full = false;
		else $export_full = true;
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Forms', 'leform').'
		<a class="add-new-h2" href="'.admin_url('admin.php').'?page=leform-add">'.esc_html__('Create New Form', 'leform').'</a>
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<form action="'.admin_url('admin.php').'" method="get" class="uap-filter-form leform-filter-form">
				<input type="hidden" name="page" value="leform" />
				<label>'.esc_html__('Search:', 'leform').'</label>
				<input type="text" name="s" style="width: 200px;" class="form-control" value="'.esc_html($search_query).'">
				<input type="submit" class="button-secondary action" value="'.esc_html__('Search', 'leform').'" />
				'.((strlen($search_query) > 0) ? '<input type="button" class="button-secondary action" value="'.esc_html__('Reset search results', 'leform').'" onclick="window.location.href=\''.admin_url('admin.php').'?page=leform\';" />' : '').'
			</form>
		</div>
		<div class="leform-top-form-right">
			<form id="leform-sorting-form" action="'.admin_url('admin.php').'" method="get" class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform" />
			<label>'.esc_html__('Sort:', 'leform').'</label>
			'.((strlen($search_query) > 0) ? '<input type="hidden" name="s" value="'.esc_html($search_query).'">' : '').'
			'.(($page > 1) ? '<input type="hidden" name="p" value="'.esc_html($page).'">' : '').'
			<select name="o" onchange="jQuery(\'#leform-sorting-form\').submit();" style="width: 150px;" class="form-control">
				<option value="name-az"'.($sort == 'name-az' ? ' selected="selected"' : '').'>'.esc_html__('Alphabetically', 'leform').' ▲</option>
				<option value="name-za"'.($sort == 'name-za' ? ' selected="selected"' : '').'>'.esc_html__('Alphabetically', 'leform').' ▼</option>
				<option value="date-az"'.($sort == 'date-az' ? ' selected="selected"' : '').'>'.esc_html__('Created', 'leform').' ▲</option>
				<option value="date-za"'.($sort == 'date-za' ? ' selected="selected"' : '').'>'.esc_html__('Created', 'leform').' ▼</option>
			</select>
			</form>
		</div>
	</div>
	<div class="leform-table-list-buttons"><a href="'.admin_url('admin.php').'?page=leform-add" class="leform-button leform-button-small"><i class="fas fa-plus"></i><label>'.esc_html__('Create New Form', 'leform').'</label></a></div>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<table class="leform-table-list widefat">
		<tr>
			<th>'.esc_html__('Name', 'leform').'</th>
			<th style="width: 360px;">'.esc_html__('Shortcode', 'leform').'</th>
			<th style="width: 60px;">'.esc_html__('Entries', 'leform').'</th>
			<th style="width: 35px;"></th>
		</tr>';
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				echo '
				<tr>
					<td><a href="'.admin_url('admin.php').'?page=leform-add&id='.esc_html($row['id']).'"><strong>'.esc_html($row['name']).'</strong></a><span class="leform-table-list-badge-status">'.($row['active'] < 1 ? '<span class="leform-badge leform-badge-danger">'.esc_html__('Inactive', 'leform').'</span>' : '').'</span><label class="leform-table-list-created">'.esc_html__('Created', 'leform').': '.$leform->unixtime_string($row['created']).'</label></td>
					<td class="leform-table-list-column-shortcode"><span class="leform-more-using" data-id="'.esc_html($row['id']).'" title="'.esc_html__('Click the icon for more options.', 'leform').'" onclick="leform_more_using_open(this);"><i class="fas fa-code"></i></span><div><input type="text" value="'.(!defined('UAP_CORE') ? '[leform id=\''.esc_html($row['id']).'\' name=\''.esc_html(str_replace("'", "", $row['name'])).'\']' : '<div class=\'leform-inline\' data-id=\''.esc_html($row['id']).'\'></div>').'" readonly="readonly" style="" onclick="this.focus();this.select();"></div></td>
					<td><a href="'.admin_url('admin.php').'?page=leform-log&form='.esc_html($row['id']).'">'.intval($row['entries']).'</a></td>
					<td>
						<div class="leform-table-list-actions">
							<span><i class="fas fa-ellipsis-v"></i></span>
							<div class="leform-table-list-menu">
								<ul>
									<li><a href="'.admin_url('admin.php').'?page=leform-add&id='.esc_html($row['id']).'">'.esc_html__('Edit', 'leform').'</a></li>
									<li><a href="#" data-status="'.($row['active'] > 0 ? 'active' : 'inactive').'" data-id="'.esc_html($row['id']).'" data-doing="'.($row['active'] > 0 ? esc_html__('Deactivating...', 'leform') : esc_html__('Activating...', 'leform')).'" onclick="return leform_forms_status_toggle(this);">'.($row['active'] > 0 ? esc_html__('Deactivate', 'leform') : esc_html__('Activate', 'leform')).'</a></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Duplicating...', 'leform').'" onclick="return leform_forms_duplicate(this);">'.esc_html__('Duplicate', 'leform').'</a></li>
									<li><a href="'.admin_url('admin.php').'?page=leform&leform-action=export&id='.esc_html($row['id']).'">'.esc_html__('Export form definition', 'leform').'</a></li>
									<li><a href="'.admin_url('admin.php').'?page=leform&leform-action=export-csv&id='.esc_html($row['id']).'">'.esc_html__('Export all records as CSV', 'leform').'</a></li>
									'.($leform->advanced_options['admin-menu-stats'] != 'off' ? '<li><a href="'.admin_url('admin.php').'?page=leform-stats&form='.esc_html($row['id']).'">'.esc_html__('Statistics', 'leform').'</a></li>' : '').'
									'.($leform->advanced_options['admin-menu-stats'] != 'off' ? '<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Reseting...', 'leform').'" onclick="return leform_stats_reset(this);">'.esc_html__('Reset Statistics', 'leform').'</a></li>' : '').'
									'.($leform->advanced_options['admin-menu-analytics'] != 'off' ? '<li><a href="'.admin_url('admin.php').'?page=leform-field-analytics&form='.esc_html($row['id']).'">'.esc_html__('Field Analytics', 'leform').'</a></li>' : '').'
									<li class="leform-table-list-menu-line"></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Deleting...', 'leform').'" onclick="return leform_forms_delete(this);">'.esc_html__('Delete', 'leform').'</a></li>
								</ul>
							</div>
						</div>
					</td>
				</tr>';
			}
		} else {
			echo '
				<tr><td colspan="4" class="leform-table-list-empty">'.((strlen($search_query) > 0) ? esc_html__('No results found for', 'leform').' "<strong>'.esc_html($search_query).'</strong>"' : esc_html__('List is empty.', 'leform')).'</td></tr>';
		}
		echo '
	</table>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<div class="leform-table-list-buttons">
		<form id="leform-import-form" enctype="multipart/form-data" method="post" action="'.admin_url('admin.php').'?page=leform&leform-action=import">
			<input id="leform-import-form-file" type="file" accept=".txt, .zip" name="leform-file" onchange="jQuery(\'#leform-import-form\').submit();">
		</form>
		<a class="leform-button leform-button-small" onclick="jQuery(\'#leform-import-form-file\').click(); return false;"><i class="fas fa-upload"></i><label>'.esc_html__('Import Form', 'leform').'</label></a>
		<a href="'.admin_url('admin.php').'?page=leform-add" class="leform-button leform-button-small"><i class="fas fa-plus"></i><label>'.esc_html__('Create New Form', 'leform').'</label></a>
	</div>
	
</div>
<div id="leform-global-message"></div>';
		echo $this->admin_dialog_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
		echo '
<div class="leform-admin-popup-overlay" id="leform-more-using-overlay"></div>
<div class="leform-admin-popup" id="leform-more-using">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_more_using_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-code"></i> '.esc_html__('How To Use', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<script>jQuery(document).ready(function(){leform_forms_ready();});</script>';
	}
	
	function admin_add_form() {
		global $wpdb, $leform;
		$predefined_options = array(
			'countries' => array(
				'label' => esc_html__('Countries', 'leform'),
				'options' => array(esc_html__("Afghanistan", "leform"),esc_html__("Albania", "leform"),esc_html__("Algeria", "leform"),esc_html__("American Samoa", "leform"),esc_html__("Andorra", "leform"),esc_html__("Angola", "leform"),esc_html__("Anguilla", "leform"),esc_html__("Antarctica", "leform"),esc_html__("Antigua And Barbuda", "leform"),esc_html__("Argentina", "leform"),esc_html__("Armenia", "leform"),esc_html__("Aruba", "leform"),esc_html__("Australia", "leform"),esc_html__("Austria", "leform"),esc_html__("Azerbaijan", "leform"),esc_html__("Bahamas", "leform"),esc_html__("Bahrain", "leform"),esc_html__("Bangladesh", "leform"),esc_html__("Barbados", "leform"),esc_html__("Belarus", "leform"),esc_html__("Belgium", "leform"),esc_html__("Belize", "leform"),esc_html__("Benin", "leform"),esc_html__("Bermuda", "leform"),esc_html__("Bhutan", "leform"),esc_html__("Bolivia", "leform"),esc_html__("Bosnia And Herzegovina", "leform"),esc_html__("Botswana", "leform"),esc_html__("Bouvet Island", "leform"),esc_html__("Brazil", "leform"),esc_html__("British Indian Ocean Territory", "leform"),esc_html__("Brunei Darussalam", "leform"),esc_html__("Bulgaria", "leform"),esc_html__("Burkina Faso", "leform"),esc_html__("Burundi", "leform"),esc_html__("Cambodia", "leform"),esc_html__("Cameroon", "leform"),esc_html__("Canada", "leform"),esc_html__("Cape Verde", "leform"),esc_html__("Cayman Islands", "leform"),esc_html__("Central African Republic", "leform"),esc_html__("Chad", "leform"),esc_html__("Chile", "leform"),esc_html__("China", "leform"),esc_html__("Christmas Island", "leform"),esc_html__("Cocos (Keeling) Islands", "leform"),esc_html__("Colombia", "leform"),esc_html__("Comoros", "leform"),esc_html__("Congo", "leform"),esc_html__("Congo, The Democratic Republic Of The", "leform"),esc_html__("Cook Islands", "leform"),esc_html__("Costa Rica", "leform"),esc_html__("Cote D'Ivoire", "leform"),esc_html__("Croatia (Local Name: Hrvatska)", "leform"),esc_html__("Cuba", "leform"),esc_html__("Cyprus", "leform"),esc_html__("Czech Republic", "leform"),esc_html__("Denmark", "leform"),esc_html__("Djibouti", "leform"),esc_html__("Dominica", "leform"),esc_html__("Dominican Republic", "leform"),esc_html__("East Timor", "leform"),esc_html__("Ecuador", "leform"),esc_html__("Egypt", "leform"),esc_html__("El Salvador", "leform"),esc_html__("Equatorial Guinea", "leform"),esc_html__("Eritrea", "leform"),esc_html__("Estonia", "leform"),esc_html__("Ethiopia", "leform"),esc_html__("Falkland Islands (Malvinas)", "leform"),esc_html__("Faroe Islands", "leform"),esc_html__("Fiji", "leform"),esc_html__("Finland", "leform"),esc_html__("France", "leform"),esc_html__("France, Metropolitan", "leform"),esc_html__("French Guiana", "leform"),esc_html__("French Polynesia", "leform"),esc_html__("French Southern Territories", "leform"),esc_html__("Gabon", "leform"),esc_html__("Gambia", "leform"),esc_html__("Georgia", "leform"),esc_html__("Germany", "leform"),esc_html__("Ghana", "leform"),esc_html__("Gibraltar", "leform"),esc_html__("Greece", "leform"),esc_html__("Greenland", "leform"),esc_html__("Grenada", "leform"),esc_html__("Guadeloupe", "leform"),esc_html__("Guam", "leform"),esc_html__("Guatemala", "leform"),esc_html__("Guinea", "leform"),esc_html__("Guinea-Bissau", "leform"),esc_html__("Guyana", "leform"),esc_html__("Haiti", "leform"),esc_html__("Heard And Mc Donald Islands", "leform"),esc_html__("Holy See (Vatican City State)", "leform"),esc_html__("Honduras", "leform"),esc_html__("Hong Kong", "leform"),esc_html__("Hungary", "leform"),esc_html__("Iceland", "leform"),esc_html__("India", "leform"),esc_html__("Indonesia", "leform"),esc_html__("Iran (Islamic Republic Of)", "leform"),esc_html__("Iraq", "leform"),esc_html__("Ireland", "leform"),esc_html__("Israel", "leform"),esc_html__("Italy", "leform"),esc_html__("Jamaica", "leform"),esc_html__("Japan", "leform"),esc_html__("Jordan", "leform"),esc_html__("Kazakhstan", "leform"),esc_html__("Kenya", "leform"),esc_html__("Kiribati", "leform"),esc_html__("Korea, Democratic People's Republic Of", "leform"),esc_html__("Korea, Republic Of", "leform"),esc_html__("Kuwait", "leform"),esc_html__("Kyrgyzstan", "leform"),esc_html__("Lao People's Democratic Republic", "leform"),esc_html__("Latvia", "leform"),esc_html__("Lebanon", "leform"),esc_html__("Lesotho", "leform"),esc_html__("Liberia", "leform"),esc_html__("Libyan Arab Jamahiriya", "leform"),esc_html__("Liechtenstein", "leform"),esc_html__("Lithuania", "leform"),esc_html__("Luxembourg", "leform"),esc_html__("Macau", "leform"),esc_html__("Macedonia, Former Yugoslav Republic Of", "leform"),esc_html__("Madagascar", "leform"),esc_html__("Malawi", "leform"),esc_html__("Malaysia", "leform"),esc_html__("Maldives", "leform"),esc_html__("Mali", "leform"),esc_html__("Malta", "leform"),esc_html__("Marshall Islands", "leform"),esc_html__("Martinique", "leform"),esc_html__("Mauritania", "leform"),esc_html__("Mauritius", "leform"),esc_html__("Mayotte", "leform"),esc_html__("Mexico", "leform"),esc_html__("Micronesia, Federated States Of", "leform"),esc_html__("Moldova, Republic Of", "leform"),esc_html__("Monaco", "leform"),esc_html__("Mongolia", "leform"),esc_html__("Montserrat", "leform"),esc_html__("Morocco", "leform"),esc_html__("Mozambique", "leform"),esc_html__("Myanmar", "leform"),esc_html__("Namibia", "leform"),esc_html__("Nauru", "leform"),esc_html__("Nepal", "leform"),esc_html__("Netherlands", "leform"),esc_html__("Netherlands Antilles", "leform"),esc_html__("New Caledonia", "leform"),esc_html__("New Zealand", "leform"),esc_html__("Nicaragua", "leform"),esc_html__("Niger", "leform"),esc_html__("Nigeria", "leform"),esc_html__("Niue", "leform"),esc_html__("Norfolk Island", "leform"),esc_html__("Northern Mariana Islands", "leform"),esc_html__("Norway", "leform"),esc_html__("Oman", "leform"),esc_html__("Pakistan", "leform"),esc_html__("Palau", "leform"),esc_html__("Panama", "leform"),esc_html__("Papua New Guinea", "leform"),esc_html__("Paraguay", "leform"),esc_html__("Peru", "leform"),esc_html__("Philippines", "leform"),esc_html__("Pitcairn", "leform"),esc_html__("Poland", "leform"),esc_html__("Portugal", "leform"),esc_html__("Puerto Rico", "leform"),esc_html__("Qatar", "leform"),esc_html__("Reunion", "leform"),esc_html__("Romania", "leform"),esc_html__("Russian Federation", "leform"),esc_html__("Rwanda", "leform"),esc_html__("Saint Kitts And Nevis", "leform"),esc_html__("Saint Lucia", "leform"),esc_html__("Saint Vincent And The Grenadines", "leform"),esc_html__("Samoa", "leform"),esc_html__("San Marino", "leform"),esc_html__("Sao Tome And Principe", "leform"),esc_html__("Saudi Arabia", "leform"),esc_html__("Senegal", "leform"),esc_html__("Seychelles", "leform"),esc_html__("Sierra Leone", "leform"),esc_html__("Singapore", "leform"),esc_html__("Slovakia (Slovak Republic)", "leform"),esc_html__("Slovenia", "leform"),esc_html__("Solomon Islands", "leform"),esc_html__("Somalia", "leform"),esc_html__("South Africa", "leform"),esc_html__("South Georgia, South Sandwich Islands", "leform"),esc_html__("Spain", "leform"),esc_html__("Sri Lanka", "leform"),esc_html__("St. Helena", "leform"),esc_html__("St. Pierre And Miquelon", "leform"),esc_html__("Sudan", "leform"),esc_html__("Suriname", "leform"),esc_html__("Svalbard And Jan Mayen Islands", "leform"),esc_html__("Swaziland", "leform"),esc_html__("Sweden", "leform"),esc_html__("Switzerland", "leform"),esc_html__("Syrian Arab Republic", "leform"),esc_html__("Taiwan", "leform"),esc_html__("Tajikistan", "leform"),esc_html__("Tanzania, United Republic Of", "leform"),esc_html__("Thailand", "leform"),esc_html__("Togo", "leform"),esc_html__("Tokelau", "leform"),esc_html__("Tonga", "leform"),esc_html__("Trinidad And Tobago", "leform"),esc_html__("Tunisia", "leform"),esc_html__("Turkey", "leform"),esc_html__("Turkmenistan", "leform"),esc_html__("Turks And Caicos Islands", "leform"),esc_html__("Tuvalu", "leform"),esc_html__("Uganda", "leform"),esc_html__("Ukraine", "leform"),esc_html__("United Arab Emirates", "leform"),esc_html__("United Kingdom", "leform"),esc_html__("United States", "leform"),esc_html__("United States Minor Outlying Islands", "leform"),esc_html__("Uruguay", "leform"),esc_html__("Uzbekistan", "leform"),esc_html__("Vanuatu", "leform"),esc_html__("Venezuela", "leform"),esc_html__("Vietnam", "leform"),esc_html__("Virgin Islands (British)", "leform"),esc_html__("Virgin Islands (U.S.)", "leform"),esc_html__("Wallis And Futuna Islands", "leform"),esc_html__("Western Sahara", "leform"),esc_html__("Yemen", "leform"),esc_html__("Yugoslavia", "leform"),esc_html__("Zambia", "leform"),esc_html__("Zimbabwe", "leform"))
			),
			'us-states' => array(
				'label' => esc_html__('U.S. States', 'leform'),
				'options' => array(esc_html__("Alabama", "leform"),esc_html__("Alaska", "leform"),esc_html__("Arizona", "leform"),esc_html__("Arkansas", "leform"),esc_html__("California", "leform"),esc_html__("Colorado", "leform"),esc_html__("Connecticut", "leform"),esc_html__("Delaware", "leform"),esc_html__("District Of Columbia", "leform"),esc_html__("Florida", "leform"),esc_html__("Georgia", "leform"),esc_html__("Hawaii", "leform"),esc_html__("Idaho", "leform"),esc_html__("Illinois", "leform"),esc_html__("Indiana", "leform"),esc_html__("Iowa", "leform"),esc_html__("Kansas", "leform"),esc_html__("Kentucky", "leform"),esc_html__("Louisiana", "leform"),esc_html__("Maine", "leform"),esc_html__("Maryland", "leform"),esc_html__("Massachusetts", "leform"),esc_html__("Michigan", "leform"),esc_html__("Minnesota", "leform"),esc_html__("Mississippi", "leform"),esc_html__("Missouri", "leform"),esc_html__("Montana", "leform"),esc_html__("Nebraska", "leform"),esc_html__("Nevada", "leform"),esc_html__("New Hampshire", "leform"),esc_html__("New Jersey", "leform"),esc_html__("New Mexico", "leform"),esc_html__("New York", "leform"),esc_html__("North Carolina", "leform"),esc_html__("North Dakota", "leform"),esc_html__("Ohio", "leform"),esc_html__("Oklahoma", "leform"),esc_html__("Oregon", "leform"),esc_html__("Pennsylvania", "leform"),esc_html__("Rhode Island", "leform"),esc_html__("South Carolina", "leform"),esc_html__("South Dakota", "leform"),esc_html__("Tennessee", "leform"),esc_html__("Texas", "leform"),esc_html__("Utah", "leform"),esc_html__("Vermont", "leform"),esc_html__("Virginia", "leform"),esc_html__("Washington", "leform"),esc_html__("West Virginia", "leform"),esc_html__("Wisconsin", "leform"),esc_html__("Wyoming", "leform"))
			),
			'canadian-provinces' => array(
				'label' => esc_html__('Canadian Provinces', 'leform'),
				'options' => array(esc_html__("Alberta", "leform"),esc_html__("British Columbia", "leform"),esc_html__("Manitoba", "leform"),esc_html__("New Brunswick", "leform"),esc_html__("Newfoundland & Labrador", "leform"),esc_html__("Northwest Territories", "leform"),esc_html__("Nova Scotia", "leform"),esc_html__("Nunavut", "leform"),esc_html__("Ontario", "leform"),esc_html__("Prince Edward Island", "leform"),esc_html__("Quebec", "leform"),esc_html__("Saskatchewan", "leform"),esc_html__("Yukon", "leform"))
			),
			'uk-counties' => array(
				'label' => esc_html__('UK Counties', 'leform'),
				'options' => array(esc_html__("Aberdeen City", "leform"),esc_html__("Aberdeenshire", "leform"),esc_html__("Angus", "leform"),esc_html__("Antrim", "leform"),esc_html__("Argyll and Bute", "leform"),esc_html__("Armagh", "leform"),esc_html__("Avon", "leform"),esc_html__("Banffshire", "leform"),esc_html__("Bedfordshire", "leform"),esc_html__("Berkshire", "leform"),esc_html__("Blaenau Gwent", "leform"),esc_html__("Borders", "leform"),esc_html__("Bridgend", "leform"),esc_html__("Bristol", "leform"),esc_html__("Buckinghamshire", "leform"),esc_html__("Caerphilly", "leform"),esc_html__("Cambridgeshire", "leform"),esc_html__("Cardiff", "leform"),esc_html__("Carmarthenshire", "leform"),esc_html__("Ceredigion", "leform"),esc_html__("Channel Islands", "leform"),esc_html__("Cheshire", "leform"),esc_html__("Clackmannan", "leform"),esc_html__("Cleveland", "leform"),esc_html__("Conwy", "leform"),esc_html__("Cornwall", "leform"),esc_html__("Cumbria", "leform"),esc_html__("Denbighshire", "leform"),esc_html__("Derbyshire", "leform"),esc_html__("Devon", "leform"),esc_html__("Dorset", "leform"),esc_html__("Down", "leform"),esc_html__("Dumfries and Galloway", "leform"),esc_html__("Durham", "leform"),esc_html__("East Ayrshire", "leform"),esc_html__("East Dunbartonshire", "leform"),esc_html__("East Lothian", "leform"),esc_html__("East Renfrewshire", "leform"),esc_html__("East Riding of Yorkshire", "leform"),esc_html__("East Sussex", "leform"),esc_html__("Edinburgh City", "leform"),esc_html__("Essex", "leform"),esc_html__("Falkirk", "leform"),esc_html__("Fermanagh", "leform"),esc_html__("Fife", "leform"),esc_html__("Flintshire", "leform"),esc_html__("Glasgow (City of)", "leform"),esc_html__("Gloucestershire", "leform"),esc_html__("Greater Manchester", "leform"),esc_html__("Gwynedd", "leform"),esc_html__("Hampshire", "leform"),esc_html__("Herefordshire", "leform"),esc_html__("Hertfordshire", "leform"),esc_html__("Highland", "leform"),esc_html__("Humberside", "leform"),esc_html__("Inverclyde", "leform"),esc_html__("Isle of Anglesey", "leform"),esc_html__("Isle of Man", "leform"),esc_html__("Isle of Wight", "leform"),esc_html__("Isles of Scilly", "leform"),esc_html__("Kent", "leform"),esc_html__("Lancashire", "leform"),esc_html__("Leicestershire", "leform"),esc_html__("Lincolnshire", "leform"),esc_html__("London", "leform"),esc_html__("Londonderry", "leform"),esc_html__("Merseyside", "leform"),esc_html__("Merthyr Tydfil", "leform"),esc_html__("Middlesex", "leform"),esc_html__("Midlothian", "leform"),esc_html__("Monmouthshire", "leform"),esc_html__("Moray", "leform"),esc_html__("Neath Port Talbot", "leform"),esc_html__("Newport", "leform"),esc_html__("Norfolk", "leform"),esc_html__("North Ayrshire", "leform"),esc_html__("North East Lincolnshire", "leform"),esc_html__("North Lanarkshire", "leform"),esc_html__("North Yorkshire", "leform"),esc_html__("Northamptonshire", "leform"),esc_html__("Northumberland", "leform"),esc_html__("Nottinghamshire", "leform"),esc_html__("Orkney", "leform"),esc_html__("Oxfordshire", "leform"),esc_html__("Pembrokeshire", "leform"),esc_html__("Perthshire and Kinross", "leform"),esc_html__("Powys", "leform"),esc_html__("Renfrewshire", "leform"),esc_html__("Rhondda Cynon Taff", "leform"),esc_html__("Roxburghshire", "leform"),esc_html__("Rutland", "leform"),esc_html__("Shetland", "leform"),esc_html__("Shropshire", "leform"),esc_html__("Somerset", "leform"),esc_html__("South Ayrshire", "leform"),esc_html__("South Lanarkshire", "leform"),esc_html__("South Yorkshire", "leform"),esc_html__("Staffordshire", "leform"),esc_html__("Stirling", "leform"),esc_html__("Suffolk", "leform"),esc_html__("Surrey", "leform"),esc_html__("Swansea", "leform"),esc_html__("The Vale of Glamorgan", "leform"),esc_html__("Torfaen", "leform"),esc_html__("Tyne and Wear", "leform"),esc_html__("Tyrone", "leform"),esc_html__("Warwickshire", "leform"),esc_html__("West Dunbartonshire", "leform"),esc_html__("West Lothian", "leform"),esc_html__("West Midlands", "leform"),esc_html__("West Sussex", "leform"),esc_html__("West Yorkshire", "leform"),esc_html__("Western Isles", "leform"),esc_html__("Wiltshire", "leform"),esc_html__("Worcestershire", "leform"),esc_html__("Wrexham", "leform"))
			),
			'german-states' => array(
				'label' => esc_html__('German States', 'leform'),
				'options' => array(esc_html__("Baden-Wurttemberg", "leform"),esc_html__("Bavaria", "leform"),esc_html__("Berlin", "leform"),esc_html__("Brandenburg", "leform"),esc_html__("Bremen", "leform"),esc_html__("Hamburg", "leform"),esc_html__("Hesse", "leform"),esc_html__("Lower Saxony", "leform"),esc_html__("Mecklenburg-West Pomerania", "leform"),esc_html__("North Rhine-Westphalia", "leform"),esc_html__("Rhineland-Palatinate", "leform"),esc_html__("Saarland", "leform"),esc_html__("Saxony", "leform"),esc_html__("Saxony-Anhalt", "leform"),esc_html__("Schleswig-Holstein", "leform"),esc_html__("Thuringia", "leform"))
			),
			'dutch-provinces' => array(
				'label' => esc_html__('Dutch Provinces', 'leform'),
				'options' => array(esc_html__("Drente", "leform"),esc_html__("Flevoland", "leform"),esc_html__("Friesland", "leform"),esc_html__("Gelderland", "leform"),esc_html__("Groningen", "leform"),esc_html__("Limburg", "leform"),esc_html__("Noord-Brabant", "leform"),esc_html__("Noord-Holland", "leform"),esc_html__("Overijssel", "leform"),esc_html__("Utrecht", "leform"),esc_html__("Zeeland", "leform"),esc_html__("Zuid-Holland", "leform"))
			),
			'australian-states' => array(
				'label' => esc_html__('Australian States', 'leform'),
				'options' => array(esc_html__("Australian Capital Territory", "leform"),esc_html__("New South Wales", "leform"),esc_html__("Northern Territory", "leform"),esc_html__("Queensland", "leform"),esc_html__("South Australia", "leform"),esc_html__("Tasmania", "leform"),esc_html__("Victoria", "leform"),esc_html__("Western Australia", "leform"))
			),
			'continents' => array(
				'label' => esc_html__('Continents', 'leform'),
				'options' => array(esc_html__("Africa", "leform"),esc_html__("Antarctica", "leform"),esc_html__("Asia", "leform"),esc_html__("Australia", "leform"),esc_html__("Europe", "leform"),esc_html__("North America", "leform"),esc_html__("South America", "leform"))
			),
			'days' => array(
				'label' => esc_html__('Days', 'leform'),
				'options' => array(esc_html__("Monday", "leform"),esc_html__("Tuesday", "leform"),esc_html__("Wednesday", "leform"),esc_html__("Thursday", "leform"),esc_html__("Friday", "leform"),esc_html__("Saturday", "leform"),esc_html__("Sunday", "leform"))
			),
			'months' => array(
				'label' => esc_html__('Months', 'leform'),
				'options' => array(esc_html__("January", "leform"),esc_html__("February", "leform"),esc_html__("March", "leform"),esc_html__("April", "leform"),esc_html__("May", "leform"),esc_html__("June", "leform"),esc_html__("July", "leform"),esc_html__("August", "leform"),esc_html__("September", "leform"),esc_html__("October", "leform"),esc_html__("November", "leform"),esc_html__("December", "leform"))
			)
		);
		$default_form_options = $leform->default_form_options();
		$form_id = null;
		$form_options = null;
		$form_details = array();
		$form_elements = array();
		if (array_key_exists('id', $_REQUEST)) {
			$form_id = intval($_REQUEST['id']);
			$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
			if (!empty($form_details)) $form_options = json_decode($form_details['options'], true);
			else $form_id = null;
		}
		if (!empty($form_options)) $form_options = array_merge($default_form_options, $form_options);
		else $form_options = $default_form_options;

		$default_page_options = $leform->default_form_options('page');
		$default_page_confirmation_options = $leform->default_form_options('page-confirmation');
		$form_pages = array(array_merge($default_page_options, array('id' => 1, 'type' => 'page')));
		
		if (!empty($form_details)) {
			$form_options['name'] = $form_details['name'];
			$form_options['active'] = $form_details['active'] > 0 ? 'on' : 'off';

			$form_pages = json_decode($form_details['pages'], true);
			if (is_array($form_pages)) {
				foreach($form_pages as $key => $page_options) {
					if (is_array($page_options)) {
						if ($page_options['type'] == 'page') $page_options = array_merge($default_page_options, $page_options);
						else $page_options = array_merge($default_page_confirmation_options, $page_options);
						$form_pages[$key] = $page_options;
					} else unset($form_pages[$key]);
				}
				$form_pages = array_values($form_pages);
			} else $form_pages = array(array_merge($default_page_options, array('id' => 1)));
			
			$form_elements = json_decode($form_details['elements'], true);
			if (is_array($form_elements)) {
				foreach($form_elements as $key => $form_element_raw) {
					$element_options = json_decode($form_element_raw, true);
					if (is_array($element_options) && array_key_exists('type', $element_options)) {
						$default_element_options = $leform->default_form_options($element_options['type']);
						$element_options = array_merge($default_element_options, $element_options);
						$form_elements[$key] = json_encode($element_options);
					} else unset($form_elements[$key]);
				}
				$form_elements = array_values($form_elements);
			} else $form_elements = array();
		}
		
		$confirmation_found = false;
		foreach($form_pages as $form_page) {
			if ($form_page['id'] == 'confirmation') {
				$confirmation_found = true;
				break;
			}
		}
		if (!$confirmation_found) {
			$form_pages[] = array_merge($default_page_confirmation_options, array('id' => 'confirmation', 'type' => 'page-confirmation', 'name' => esc_html__('Confirmation', 'leform')));
			$default_element_options = $leform->default_form_options('html');
			$element_options = array(
				"type" => 'html',
				"_parent" => 'confirmation',
				"_parent-col" => 0, 
				"_seq" => 0, 
				"id" => 0,
				"content" => '<h4 style="text-align: center;">Thank you!</h4><p style="text-align: center;">We will contact you soon.</p>'
			);
			$element_options = array_merge($default_element_options, $element_options);
			$form_elements[] = json_encode($element_options);
		}
		echo (!empty($form_id) ? '<script>leform_gettingstarted_enable = "off";</script>' : '').'
<style>body {position: absolute; width: 100%;}
.mce-menu .mce-menu-item-normal.mce-active, .mce-menu .mce-menu-item-preview.mce-active, .mce-menu .mce-menu-item.mce-selected, .mce-menu .mce-menu-item:focus, .mce-menu .mce-menu-item:hover {background: #26B99A; color: #fff !important;}
.mce-menu .mce-menu-item-normal.mce-active span, .mce-menu .mce-menu-item-preview.mce-active span, .mce-menu .mce-menu-item.mce-selected span, .mce-menu .mce-menu-item:focus span, .mce-menu .mce-menu-item:hover span {color: #fff !important;}
</style>
<div class="wrap leform-admin leform-admin-editor">
	<h2>'.esc_html__('Green Forms - Edit Form', 'leform').'
		<a class="add-new-h2" href="'.admin_url('admin.php').'?page=leform-add">'.esc_html__('Create New Form', 'leform').'</a>
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
<div class="leform-form-editor">
	<div class="leform-toolbars">
		<div class="leform-header">
			<div class="leform-header-settings"><span data-type="settings" onclick="return leform_properties_open(this);"><i class="fas fa-cogs"></i></span></div>
			<div class="leform-header-save"><span onclick="return leform_save(this);"><i class="far fa-save"></i>'.esc_html__('Save', 'leform').'</span></div>
			<div class="leform-header-preview"><span'.(!empty($form_id) ? ' data-id="'.esc_html($form_id).'"' : ' style="display: none;"').' onclick="leform_preview(this);"><i class="far fa-eye"></i></span></div>
			<div class="leform-header-using"><span'.(!empty($form_id) ? ' data-id="'.esc_html($form_id).'"' : ' style="display: none;"').' onclick="leform_more_using_open(this);"><i class="fas fa-code"></i></span></div>
		</div>
		<div class="leform-pages-bar">
			<ul class="leform-pages-bar-items">';
			foreach ($form_pages as $form_page) {
				if ($form_page['id'] == 'confirmation') {
					echo '
				<li class="leform-pages-bar-item-confirmation" data-id="'.esc_html($form_page['id']).'" data-name="'.esc_html($form_page['name']).'"><label onclick="return leform_pages_activate(this);">'.esc_html($form_page['name']).'</label><span><a href="#" data-type="page-confirmation" onclick="return leform_properties_open(this);"><i class="fas fa-cog"></i></a></span></li>';
				} else {
					echo '
				<li class="leform-pages-bar-item" data-id="'.esc_html($form_page['id']).'" data-name="'.esc_html($form_page['name']).'"><label onclick="return leform_pages_activate(this);">'.esc_html($form_page['name']).'</label><span><a href="#" data-type="page" onclick="return leform_properties_open(this);"><i class="fas fa-cog"></i></a><a href="#" class="leform-pages-bar-item-delete'.(sizeof($form_pages) <= 1 ? ' leform-pages-bar-item-delete-disabled' : '').'" onclick="return leform_pages_delete(this);"><i class="fas fa-trash-alt"></i></a></span></li>';
				}
			}
			echo '
				<li class="leform-pages-add" onclick="return leform_pages_add();"><label><i class="fas fa-plus"></i> '.esc_html__('Add Page', 'leform').'</label></li>
			</ul>
		</div>
		<div class="leform-toolbar">
			<ul class="leform-toolbar-list">';
			foreach ($leform->toolbar_tools as $key => $value) {
				if (array_key_exists('options', $value)) {
					echo '
				<li class="leform-toolbar-tool-'.esc_html($value['type']).'" class="leform-toolbar-list-options" data-type="'.esc_html($key).'" data-option="2"><a href="#" title="'.esc_html($value['title']).'"><i class="'.esc_html($value['icon']).'"></i></a><ul>';
					foreach ($value['options'] as $option_key => $option_value) {
						echo '<li data-type="'.esc_html($key).'" data-option="'.esc_html($option_key).'" title=""><a href="#" title="'.esc_html($value['title']).'">'.esc_html($option_value).'</a></li>';
					}
					echo '</ul></li>';
					
				} else {
					echo '
				<li class="leform-toolbar-tool-'.esc_html($value['type']).'" data-type="'.esc_html($key).'"><a href="#" title="'.esc_html($value['title']).'"><i class="'.esc_html($value['icon']).'"></i></a></li>';
				}
			}
			echo '
			</ul>
		</div>
	</div>
	<div class="leform-builder"><div class="leform-form-global-style"></div>';
		foreach ($form_pages as $form_page) {
			echo '
			<div id="leform-form-'.esc_html($form_page['id']).'" class="leform-form leform-elements" _data-parent="'.esc_html($form_page['id']).'" _data-parent-col="0"></div>';
		}
		echo '
	</div>
</div>
<iframe data-loading="false" id="leform-import-style-iframe" name="leform-import-style-iframe" src="about:blank" onload="leform_stylemanager_imported(this);"></iframe>
<form id="leform-import-style-form" enctype="multipart/form-data" method="post" target="leform-import-style-iframe" action="'.admin_url('admin.php').'?page=leform&leform-action=import-style">
	<input id="leform-import-style-file" type="file" accept=".txt, .zip" name="leform-file" onchange="jQuery(\'#leform-import-style-iframe\').attr(\'data-loading\', \'true\'); jQuery(\'#leform-import-style-form\').submit();">
</form>
<div class="leform-admin-popup-overlay" id="leform-element-properties-overlay"></div>
<div class="leform-admin-popup" id="leform-element-properties">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_properties_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-cog"></i> '.esc_html__('Element Properties', 'leform').'</h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-buttons">
			<a class="leform-admin-button" href="#" onclick="return leform_properties_save();"><i class="fas fa-check"></i><label>'.esc_html__('Save Details', 'leform').'</label></a>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<div class="leform-fa-selector-overlay"></div>
<div class="leform-fa-selector">
	<div class="leform-fa-selector-inner">
		<div class="leform-fa-selector-header">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_fa_selector_close();"><i class="fas fa-times"></i></a>
			<input type="text" placeholder="'.esc_html__('Search...', 'leform').'">
		</div>
		<div class="leform-fa-selector-content">
			<span title="No icon" onclick="leform_fa_selector_set(this);"><i class=""></i></span>';
		if ($leform->options['fa-enable'] == 'on') {
			if ($leform->options['fa-solid-enable'] == 'on') {
				foreach ($leform->fa_solid as $value) {
					echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="fas fa-'.esc_html($value).'"></i></span>';
				}
			}
			if ($leform->options['fa-regular-enable'] == 'on') {
				foreach ($leform->fa_regular as $value) {
					echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="far fa-'.esc_html($value).'"></i></span>';
				}
			}
			if ($leform->options['fa-brands-enable'] == 'on') {
				foreach ($leform->fa_brands as $value) {
					echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="fab fa-'.esc_html($value).'"></i></span>';
				}
			}
		} else {
			foreach ($leform->font_awesome_basic as $value) {
				echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="leform-fa leform-fa-'.esc_html($value).'"></i></span>';
			}
		}
		echo '
		</div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-bulk-options-overlay"></div>
<div class="leform-admin-popup" id="leform-bulk-options">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_bulk_options_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-list-ul"></i> '.esc_html__('Add Bulk Options', 'leform').'</h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
				<div class="leform-bulk-options-text">'.esc_html__('Click a category on the left side to insert predefined options. You can edit the options on the right side or enter your own options. One option per line!', 'leform').'</div>
				<div class="leform-bulk-options-container">
					<div class="leform-bulk-categories">
						<ul>
							<li data-category="existing" onclick="return leform_bulk_category_add(this);"><i class="fas fa-plus"></i> '.esc_html__('Existing Options', 'leform').'</li>';
		foreach($predefined_options as $key => $value) {
			echo '
							<li data-category="'.esc_html($key).'" onclick="return leform_bulk_category_add(this);"><i class="fas fa-plus"></i> '.esc_html($value['label']).'</li>';
		}
		echo '
						</ul>
					</div>
					<div class="leform-bulk-editor">
						<textarea></textarea>
					</div>
				</div>
				<div class="leform-bulk-options-text"><input class="leform-checkbox-toggle" type="checkbox" id="leform-bulk-options-overwrite"><label for="leform-bulk-options-overwrite"></label> '.esc_html__('Overwrite existing options', 'leform').'</div>
			</div>
		</div>
		<div class="leform-admin-popup-buttons">
			<a class="leform-admin-button" href="#" onclick="return leform_bulk_options_add();"><i class="fas fa-plus"></i><label>'.esc_html__('Add Options', 'leform').'</label></a>
		</div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-more-using-overlay"></div>
<div class="leform-admin-popup" id="leform-more-using">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_more_using_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-code"></i> '.esc_html__('How To Use', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-stylemanager-overlay"></div>
<div class="leform-admin-popup" id="leform-stylemanager">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_stylemanager_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-code"></i> '.esc_html__('Theme Manager', 'leform').'</h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-preview-overlay"></div>
<div class="leform-admin-popup" id="leform-preview" data-width="1600">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_preview_close();"><i class="fas fa-times"></i></a>
			<span class="leform-preview-size-mobile" data-width="480" onclick="leform_preview_size(this);"><i class="fas fa-mobile-alt"></i></span>
			<span class="leform-preview-size-tablet" data-width="960" onclick="leform_preview_size(this);"><i class="fas fa-tablet-alt"></i></span>
			<span class="leform-preview-size-desktop leform-preview-size-active" data-width="1600" onclick="leform_preview_size(this);"><i class="fas fa-tv"></i></span>
			<h3><i class="far fa-eye"></i> '.esc_html__('Preview', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content"><iframe data-loading="false" id="leform-preview-iframe" name="leform-preview-iframe" src="about:blank" onload="leform_preview_loaded(this);"></iframe></div>
	</div>
</div>
<div id="leform-global-message"></div>';
		if (empty($form_id)) {
			echo '
<div class="leform-admin-create-overlay">
	<div class="leform-admin-create">
		<div class="leform-admin-create-content">
			<div>
				<input type="text" id="leform-create-name" value="" placeholder="'.esc_html__('Please enter the form name...', 'leform').'" />
			</div>
			<div class="leform-admin-buttons-create">
				<a class="leform-admin-button leform-admin-button-create" onclick="return leform_create();"><i class="fas fa-check"></i> '.esc_html__('Create New Form', 'leform').'</a>
			</div>
		</div>
	</div>
</div>';
		}
		echo $this->admin_dialog_html();
		$webfonts_array = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_webfonts WHERE deleted = '0' ORDER BY family", ARRAY_A);
		$webfonts = array();
		foreach ($webfonts_array as $webfont) {
			$webfonts[] = $webfont['family'];
		}
		$custom_fonts_raw = explode("\n", $leform->advanced_options['custom-fonts']);
		$custom_fonts = array();
		foreach ($custom_fonts_raw as $font) {
			$font = trim($font);
			$font = trim($font, "'\"`");
			if (!empty($font)) $custom_fonts[] = $font;
		}
		$providers = array();
		$providers = apply_filters('leform_providers', $providers);
		$payment_providers = array();
		$payment_providers = apply_filters('leform_payment_providers', $payment_providers);
		
		$styles = $leform->get_styles();
		echo '
<input type="hidden" id="leform-id" value="'.intval($form_id).'" />
<script>
	var leform_webfonts = '.json_encode($webfonts).';
	var leform_localfonts = '.json_encode($leform->local_fonts).';
	var leform_customfonts = '.json_encode($custom_fonts).';
	var leform_toolbar_tools = '.json_encode($leform->toolbar_tools).';
	var leform_meta = '.json_encode($leform->element_properties_meta).';
	var leform_validators = '.json_encode($leform->validators_meta).';
	var leform_filters = '.json_encode($leform->filters_meta).';
	var leform_confirmations = '.json_encode($leform->confirmations_meta).';
	var leform_notifications = '.json_encode($leform->notifications_meta).';
	var leform_integrations = '.json_encode($leform->integrations_meta).';
	var leform_payment_gateway = '.json_encode($leform->payment_gateways_meta).';
	var leform_math_expressions_meta = '.json_encode($leform->math_meta).';
	var leform_logic_rules = '.json_encode($leform->logic_rules).';
	var leform_predefined_options = '.json_encode($predefined_options).';
	var leform_form_options = '.json_encode($form_options).';
	var leform_form_pages_raw = '.json_encode($form_pages).';
	var leform_form_elements_raw = '.json_encode($form_elements).';
	var leform_integration_providers = '.json_encode($providers).';
	var leform_payment_providers = '.json_encode($payment_providers).';
	var leform_styles = '.json_encode($styles).';
	jQuery(document).ready(function(){leform_form_ready();});
</script>
</div>';
	}

	function admin_dialog_html() {
		return '
<div class="leform-dialog-overlay" id="leform-dialog-overlay"></div>
<div class="leform-dialog" id="leform-dialog">
	<div class="leform-dialog-inner">
		<div class="leform-dialog-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_dialog_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-cog"></i><label></label></h3>
		</div>
		<div class="leform-dialog-content">
			<div class="leform-dialog-content-html">
			</div>
		</div>
		<div class="leform-dialog-buttons">
			<a class="leform-dialog-button leform-dialog-button-ok" href="#" onclick="return false;"><i class="fas fa-check"></i><label></label></a>
			<a class="leform-dialog-button leform-dialog-button-cancel" href="#" onclick="return false;"><i class="fas fa-times"></i><label></label></a>
		</div>
		<div class="leform-dialog-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>';
	}

	function admin_records() {
		global $wpdb, $leform;

		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		
		if (isset($_GET["form"])) $form_id = intval(stripslashes($_GET["form"]));
		else $form_id = 0;
		$forms = $wpdb->get_results("SELECT DISTINCT t1.form_id, t2.deleted, t2.name AS form_name FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' ORDER BY t2.name ASC", ARRAY_A);

		$filter = '';
		if ($form_id > 0) $filter = " AND t1.form_id = '".esc_sql($form_id)."'";
		if (!empty($search_query)) $filter .= " AND (t1.fields LIKE '%".esc_sql($wpdb->esc_like($search_query))."%' OR t1.id LIKE '%".esc_sql($wpdb->esc_like($search_query))."%')";
		
		$tmp = $wpdb->get_row("SELECT COUNT(*) AS total FROM ".$wpdb->prefix."leform_records t1 WHERE t1.deleted = '0'".$filter, ARRAY_A);
		$total = $tmp["total"];
		$totalpages = ceil($total/LEFORM_RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = $leform->page_switcher(admin_url('admin.php').'?page=leform-log'.($form_id > 0 ? '&form='.rawurlencode($form_id) : '').((strlen($search_query) > 0) ? '&s='.rawurlencode($search_query) : ''), $page, $totalpages);
		
		$sql = "SELECT t1.*, t2.name AS form_name, t2.options AS form_options, t2.deleted AS form_deleted FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0'".$filter." ORDER BY t1.created DESC LIMIT ".esc_sql(($page-1)*LEFORM_RECORDS_PER_PAGE).", ".esc_sql(LEFORM_RECORDS_PER_PAGE);
		$rows = $wpdb->get_results($sql, ARRAY_A);

		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Log', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<form action="'.admin_url('admin.php').'" method="get"  class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform-log" />
			'.($form_id > 0 ? '<input type="hidden" name="form" value="'.esc_html($form_id).'" />' : '').'
			<label>'.esc_html__('Search', 'leform').':</label>
			<input type="text" name="s" class="form-control" style="width: 200px;" value="'.esc_html($search_query).'">
			<input type="submit" class="button-secondary action" value="'.esc_html__('Search', 'leform').'" />
			'.((strlen($search_query) > 0) ? '<input type="button" class="button-secondary action" value="'.esc_html__('Reset search results', 'leform').'" onclick="window.location.href=\''.admin_url('admin.php').'?page=leform-log'.($form_id > 0 ? '&form='.rawurlencode($form_id) : '').'\';" />' : '').'
			</form>
		</div>
		<div class="leform-top-form-right">
			<form id="leform-filter-form" action="'.admin_url('admin.php').'" method="get"  class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform-log" />
			<label>'.esc_html__('Filter:', 'leform').'</label>
			<select name="form" class="form-control" style="width: 150px;" onchange="jQuery(\'#leform-filter-form\').submit();">
				<option value="">'.esc_html__('All Forms', 'leform').'</option>';
			foreach ($forms as $form) {
				echo '
				<option value="'.esc_html($form['form_id']).'"'.($form['form_id'] == $form_id ? ' selected="selected"' : '').'>'.esc_html($form['form_name']).($form['deleted'] == 1 ? ' [deleted]': '').'</option>';
			}
			echo '
			</select>
			</form>
		</div>
	</div>
	<div class="leform-table-list-buttons">
		<div class="leform-column-settings">
			<span><i class="fas fa-wrench"></i></span>
			<div class="leform-column-menu">
				<ul class="leform-log-columns" data-id="log">
					<li><input class="leform-checkbox leform-checkbox-tgl leform-checkbox-small" id="leform-column-id" data-id="id" type="checkbox" checked="checked" onchange="leform_columns_toggle(this);" /><label for="leform-column-id"></label><label for="leform-column-id">'.esc_html__('ID', 'leform').'</label></li>
					<li><input class="leform-checkbox leform-checkbox-tgl leform-checkbox-small" id="leform-column-primary" data-id="primary" type="checkbox" checked="checked" onchange="leform_columns_toggle(this);" /><label for="leform-column-primary"></label><label for="leform-column-primary">'.esc_html__('Primary Field', 'leform').'</label></li>
					<li><input class="leform-checkbox leform-checkbox-tgl leform-checkbox-small" id="leform-column-secondary" data-id="secondary" type="checkbox" checked="checked" onchange="leform_columns_toggle(this);" /><label for="leform-column-secondary"></label><label for="leform-column-secondary">'.esc_html__('Secondray Field', 'leform').'</label></li>
					<li><input class="leform-checkbox leform-checkbox-tgl leform-checkbox-small" id="leform-column-form" data-id="form" type="checkbox" checked="checked" onchange="leform_columns_toggle(this);" /><label for="leform-column-form"></label><label for="leform-column-form">'.esc_html__('Form', 'leform').'</label></li>
					<li><input class="leform-checkbox leform-checkbox-tgl leform-checkbox-small" id="leform-column-amount" data-id="amount" type="checkbox" checked="checked" onchange="leform_columns_toggle(this);" /><label for="leform-column-amount"></label><label for="leform-column-amount">'.esc_html__('Amount', 'leform').'</label></li>
					<li><input class="leform-checkbox leform-checkbox-tgl leform-checkbox-small" id="leform-column-created" data-id="created" type="checkbox" checked="checked" onchange="leform_columns_toggle(this);" /><label for="leform-column-created"></label><label for="leform-column-created">'.esc_html__('Created', 'leform').'</label></li>
				</ul>
			</div>
		</div>
	</div>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<table id="leform-table-log" class="leform-table-list widefat" style="display:none;">
		<tr>
			<th class="leform-column leform-column-id">'.esc_html__('ID', 'leform').'</th>
			<th class="leform-column leform-column-primary">'.esc_html__('Primary Field', 'leform').'</th>
			<th class="leform-column leform-column-secondary">'.esc_html__('Secondray Field', 'leform').'</th>
			<th class="leform-column leform-column-form">'.esc_html__('Form', 'leform').'</th>
			<th class="leform-column leform-column-amount" style="width: 100px;">'.esc_html__('Amount', 'leform').'</th>
			<th class="leform-column leform-column-created" style="width: 130px;">'.esc_html__('Created', 'leform').'</th>
			<th class="leform-column leform-column-actions" style="width: 35px;"></th>
		</tr>';
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				$primary_field = '<a href="#" onclick="return leform_record_details_open(this);" data-id="'.esc_html($row['id']).'"><strong>-</strong></a>';
				$secondary_field = '-';
				$form_options = json_decode($row['form_options'], true);
				if (!empty($form_options) && is_array($form_options)) {
					$fields = json_decode($row['fields'], true);
					if (!empty($fields) && is_array($fields)) {
						if (array_key_exists($form_options['key-fields-primary'], $fields) && !empty($fields[$form_options['key-fields-primary']])) {
							$primary_field = '<a href="#" onclick="return leform_record_details_open(this);" data-id="'.esc_html($row['id']).'"><strong>'.esc_html($fields[$form_options['key-fields-primary']]).'</strong></a>';
						}
						if (array_key_exists($form_options['key-fields-secondary'], $fields) && !empty($fields[$form_options['key-fields-secondary']])) {
							$secondary_field = esc_html($fields[$form_options['key-fields-secondary']]);
						}
					}
				}
				if ($row['status'] == LEFORM_RECORD_STATUS_UNCONFIRMED) $primary_field .= '<span class="leform-badge leform-badge-danger">'.esc_html__('Unconfirmed', 'leform').'</span>';
				else if ($row['status'] == LEFORM_RECORD_STATUS_CONFIRMED) $primary_field .= '<span class="leform-badge leform-badge-success">'.esc_html__('Confirmed', 'leform').'</span>';
				echo '
				<tr>
					<td class="leform-column leform-column-id">'.esc_html($row['id']).'</td>
					<td class="leform-column leform-column-primary">'.$primary_field.'</td>
					<td class="leform-column leform-column-secondary">'.$secondary_field.'</td>
					<td class="leform-column leform-column-form">'.($row['form_deleted'] == 0 ? '<a href="'.admin_url('admin.php').'?page=leform-add&id='.esc_html($row['form_id']).'">'.esc_html($row['form_name']).'</a>' : esc_html($row['form_name']).' ('.esc_html__('deleted', 'leform').')').'</td>
					<td class="leform-column leform-column-amount">'.($row['amount'] > 0 ? '<a href="'.admin_url('admin.php').'?page=leform-transactions&record='.rawurlencode($row['id']).'">'.($row['currency'] != 'BTC' ? number_format($row['amount'], 2, '.', '') : number_format($row['amount'], 8, '.', '')).' '.esc_html($row['currency']).'</a>'.($row['status'] == LEFORM_RECORD_STATUS_PAID ? '<span class="leform-badge leform-badge-success">'.esc_html__('Paid', 'leform').'</span>' : '<span class="leform-badge leform-badge-danger">'.esc_html__('Unpaid', 'leform').'</span>') : '-').'</td>
					<td class="leform-column leform-column-created">'.$leform->unixtime_string($row['created']).'</td>
					<td class="leform-column leform-column-actions">
						<div class="leform-table-list-actions">
							<span><i class="fas fa-ellipsis-v"></i></span>
							<div class="leform-table-list-menu">
								<ul>
									<li><a href="#" onclick="return leform_record_details_open(this);" data-id="'.esc_html($row['id']).'">'.esc_html__('Details', 'leform').'</a></li>
									'.($leform->advanced_options['admin-menu-transactions'] != 'off' ? '<li><a href="'.admin_url('admin.php').'?page=leform-transactions&record='.esc_html($row['id']).'">'.esc_html__('Transactions', 'leform').'</a></li>' : '').'
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Deleting...', 'leform').'" onclick="return leform_records_delete(this);">'.esc_html__('Delete', 'leform').'</a></li>
								</ul>
							</div>
						</div>
					</td>
				</tr>';
			}
		} else {
			echo '
				<tr><td colspan="6" class="leform-table-list-empty">'.((strlen($search_query) > 0) ? esc_html__('No results found for', 'leform').' "<strong>'.esc_html($search_query).'</strong>"' : esc_html__('List is empty.', 'leform')).'</td></tr>';
		}
		echo '
	</table>
	<script>leform_columns_toggle("log");jQuery("#leform-table-log").show();</script>
	<div class="leform-pageswitcher">'.$switcher.'</div>
</div>
<div id="leform-global-message"></div>';
		echo $this->admin_dialog_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
		echo '
<div class="leform-admin-popup-overlay" id="leform-record-details-overlay"></div>
<div class="leform-admin-popup" id="leform-record-details">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_record_details_close();"><i class="fas fa-times"></i></a>
			<span class="leform-export-pdf" data-url="'.admin_url('admin.php').'?page=leform&leform-action=log-record-pdf&id={ID}"><a target="_blank" href="#"><i class="fas fa-file-pdf"></i></a></span>
			<span class="leform-print" data-url="'.admin_url('admin.php').'?page=leform&leform-action=log-record-print&id={ID}"><a target="_blank" href="#"><i class="fas fa-print"></i></a></span>
			<h3><i class="fas fa-cog"></i> '.esc_html__('Record Details', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<script>jQuery(document).ready(function(){leform_log_ready();});</script>';
 	}

	function admin_stats() {
		global $wpdb, $leform;

		if (array_key_exists('form', $_REQUEST) && $_REQUEST['form'] > 0) $form_id = intval(stripslashes($_REQUEST["form"]));
		else $form_id = null;
		$forms = $wpdb->get_results("SELECT DISTINCT t1.form_id, t2.deleted, t2.name AS form_name FROM ".$wpdb->prefix."leform_stats t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' AND t2.deleted = '0' ORDER BY t2.name ASC", ARRAY_A);

		$start_date = new DateTime(date("Y-m-01", time()+3600*$leform->gmt_offset));
		$end_date = new DateTime(date("Y-m-t", time()+3600*$leform->gmt_offset));
		
		$output = $leform->stats_array($form_id, $start_date, $end_date);
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Stats', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<div class="leform-stats-filter">
				<div class="leform-stats-select-container">
					<select id="leform-stats-form" onchange="">
						<option value="0">'.esc_html__('All Forms', 'leform').'</option>';
				foreach ($forms as $form) {
					echo '
						<option value="'.esc_html($form['form_id']).'"'.($form['form_id'] == $form_id ? ' selected="selected"' : '').'>'.esc_html($form['form_name']).($form['deleted'] == 1 ? ' [deleted]': '').'</option>';
				}
				echo '
					</select>
					<label>'.esc_html__('Form', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container">
					<input type="text" id="leform-stats-date-start" class="leform-stats-date" value="'.date('Y-m-01', time()+3600*$leform->gmt_offset).'" />
					<label>'.esc_html__('Start date', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container">
					<input type="text" id="leform-stats-date-end" class="leform-stats-date" value="'.date('Y-m-t', time()+3600*$leform->gmt_offset).'" />
					<label>'.esc_html__('End date', 'leform').'</label>
				</div>
				<a class="leform-stats-button" onclick="return leform_stats_load(this);"><i class="fas fa-check"></i><label>'.esc_html__('Apply', 'leform').'</label></a>
			</div>
		</div>
	</div>
	<canvas id="leform-stats"></canvas>
</div>
<input type="hidden" id="leform-stats-initial-data" value="'.esc_html(json_encode($output)).'" />
<script>jQuery(document).ready(function(){leform_stats_ready();});</script>
<div id="leform-global-message"></div>';
		echo $this->admin_dialog_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
 	}

	function admin_field_analytics() {
		global $wpdb, $leform;

		if (array_key_exists('form', $_REQUEST) && $_REQUEST['form'] > 0) $form_id = intval(stripslashes($_REQUEST["form"]));
		else $form_id = null;
		$forms = $wpdb->get_results("SELECT DISTINCT t1.form_id, t2.deleted, t2.name AS form_name FROM ".$wpdb->prefix."leform_stats t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' && t2.deleted = '0' ORDER BY t2.name ASC", ARRAY_A);

		$start_date = new DateTime('2000-01-01');
		$end_date = new DateTime('2030-12-31');
		
		$output = array();
		if ($form_id > 0) {
			if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
			$form_object = new leform_form(intval($form_id), true);
			if (!empty($form_object->id)) {
				$output = $form_object->field_analytics_array($start_date, $end_date);
			} else $form_id = null;
		}
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Field Analytics', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<div class="leform-stats-filter">
				<div class="leform-stats-select-container">
					<select id="leform-stats-form" onchange="">
						<option value="0">'.esc_html__('Select the form', 'leform').'</option>';
				foreach ($forms as $form) {
					echo '
						<option value="'.esc_html($form['form_id']).'"'.($form['form_id'] == $form_id ? ' selected="selected"' : '').'>'.esc_html($form['form_name']).($form['deleted'] == 1 ? ' [deleted]': '').'</option>';
				}
				echo '
					</select>
					<label>'.esc_html__('Form', 'leform').'</label>
				</div>
				<div class="leform-stats-radio-container">
					<div class="leform-stats-radio-toggle-container">
						<input class="leform-checkbox-toggle" type="checkbox" value="off" id="leform-stats-period" /><label for="leform-stats-period"></label>
					</div>
					<label>'.esc_html__('Period', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container" style="display:none;">
					<input type="text" id="leform-stats-date-start" class="leform-stats-date" value="'.date('Y-m-01', time()+3600*$leform->gmt_offset).'" />
					<label>'.esc_html__('Start date', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container" style="display:none;">
					<input type="text" id="leform-stats-date-end" class="leform-stats-date" value="'.date('Y-m-t', time()+3600*$leform->gmt_offset).'" />
					<label>'.esc_html__('End date', 'leform').'</label>
				</div>
				<a class="leform-stats-button" onclick="return leform_field_analytics_load(this);"><i class="fas fa-check"></i><label>'.esc_html__('Apply', 'leform').'</label></a>
			</div>
		</div>
	</div>
	<div class="leform-field-analytics-container">
		'.(empty($form_id) ? '<div class="leform-field-analytics-noform">'.esc_html__('No form selected.', 'leform').'</div>' : '').'
	</div>
</div>
<input type="hidden" id="leform-field-analytics-initial-data" value="'.esc_html(json_encode($output)).'" />
<script>jQuery(document).ready(function(){leform_field_analytics_ready();});</script>
<div id="leform-global-message"></div>';
		echo $this->admin_dialog_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
 	}

	function admin_transactions() {
		global $wpdb, $leform;

		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		if (isset($_GET["record"])) $record_id = intval(stripslashes($_GET["record"]));
		else $record_id = 0;
		
		$filter = '';
		if ($record_id > 0) $filter = " AND t1.record_id = '".esc_sql($record_id)."'";
		if (!empty($search_query)) $filter .= " AND (t1.payer_name LIKE '%".esc_sql($wpdb->esc_like($search_query))."%' OR t1.payer_email LIKE '%".esc_sql($wpdb->esc_like($search_query))."%' OR t1.details LIKE '%".esc_sql($wpdb->esc_like($search_query))."%')";
		
		$tmp = $wpdb->get_row("SELECT COUNT(*) AS total FROM ".$wpdb->prefix."leform_transactions t1 WHERE t1.deleted = '0'".$filter, ARRAY_A);
		$total = $tmp["total"];
		$totalpages = ceil($total/LEFORM_RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = $leform->page_switcher(admin_url('admin.php').'?page=leform-transactions'.($record_id > 0 ? '&record='.rawurlencode($record_id) : '').((strlen($search_query) > 0) ? '&s='.rawurlencode($search_query) : ''), $page, $totalpages);
		
		$sql = "SELECT t1.*, t2.form_id AS form_id FROM ".$wpdb->prefix."leform_transactions t1 LEFT JOIN ".$wpdb->prefix."leform_records t2 ON t2.id = t1.record_id WHERE t1.deleted = '0'".$filter." ORDER BY t1.created DESC LIMIT ".esc_sql(($page-1)*LEFORM_RECORDS_PER_PAGE).", ".esc_sql(LEFORM_RECORDS_PER_PAGE);
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Transactions', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/documentation/#standalone-script' : 'https://greenforms.pro/documentation/#wordpress-plugin').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<form action="'.admin_url('admin.php').'" method="get"  class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform-transactions" />
			'.($record_id > 0 ? '<input type="hidden" name="record" value="'.esc_html($record_id).'" />' : '').'
			<label>'.esc_html__('Search', 'leform').':</label>
			<input type="text" name="s" class="form-control" style="width: 200px;" value="'.esc_html($search_query).'">
			<input type="submit" class="button-secondary action" value="'.esc_html__('Search', 'leform').'" />
			'.((strlen($search_query) > 0) ? '<input type="button" class="button-secondary action" value="'.esc_html__('Reset search results', 'leform').'" onclick="window.location.href=\''.admin_url('admin.php').'?page=leform-transactions'.($record_id > 0 ? '&record='.rawurlencode($record_id) : '').'\';" />' : '').'
			</form>
		</div>
		<div class="leform-top-form-right">
		</div>
	</div>
	<div class="leform-table-list-buttons"></div>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<table class="leform-table-list widefat">
		<tr>
			<th>'.esc_html__('Payer', 'leform').'</th>
			<th>'.esc_html__('Status', 'leform').'</th>
			<th style="width: 120px;">'.esc_html__('Amount', 'leform').'</th>
			<th style="width: 130px;">'.esc_html__('Created', 'leform').'</th>
			<th style="width: 35px;"></th>
		</tr>';
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				echo '
				<tr>
					<td><a href="#" onclick="return leform_transaction_details_open(this);" data-id="'.esc_html($row['id']).'"><strong>'.esc_html($row['payer_name']).'</strong><label class="leform-table-list-created">'.esc_html($row['payer_email']).'</label></a></td>
					<td><a href="#" onclick="return leform_transaction_details_open(this);" data-id="'.esc_html($row['id']).'">'.esc_html($row["payment_status"]).'</a><label class="leform-table-list-created">'.esc_html($row["transaction_type"]).'</label></td>
					<td>'.($row['currency'] == 'BTC' ? number_format($row['gross'], 8, ".", "") : number_format($row['gross'], 2, ".", "")).' '.$row['currency'].'</td>
					<td>'.$leform->unixtime_string($row['created']).'</td>
					<td>
						<div class="leform-table-list-actions">
							<span><i class="fas fa-ellipsis-v"></i></span>
							<div class="leform-table-list-menu">
								<ul>
									<li><a href="#" onclick="return leform_transaction_details_open(this);" data-id="'.esc_html($row['id']).'">'.esc_html__('Details', 'leform').'</a></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Deleting...', 'leform').'" onclick="return leform_transactions_delete(this);">'.esc_html__('Delete', 'leform').'</a></li>
								</ul>
							</div>
						</div>
					</td>
				</tr>';
			}
		} else {
			echo '
				<tr><td colspan="5" class="leform-table-list-empty">'.((strlen($search_query) > 0) ? esc_html__('No results found for', 'leform').' "<strong>'.esc_html($search_query).'</strong>"' : esc_html__('List is empty.', 'leform')).'</td></tr>';
		}
		echo '
	</table>
	<div class="leform-pageswitcher">'.$switcher.'</div>
</div>
<div id="leform-global-message"></div>';
		echo $this->admin_dialog_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
		echo '
<div class="leform-admin-popup-overlay" id="leform-record-details-overlay"></div>
<div class="leform-admin-popup" id="leform-record-details">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_record_details_close();"><i class="fas fa-times"></i></a>
			<span class="leform-export-pdf" data-url="'.admin_url('admin.php').'?page=leform&leform-action=transaction-pdf&id={ID}"><a target="_blank" href="#"><i class="fas fa-file-pdf"></i></a></span>
			<span class="leform-print" data-url="'.admin_url('admin.php').'?page=leform&leform-action=transaction-print&id={ID}"><a target="_blank" href="#"><i class="fas fa-print"></i></a></span>
			<h3><i class="fas fa-cog"></i> '.esc_html__('Transaction Details', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<script>jQuery(document).ready(function(){leform_log_ready();});</script>';
 	}
	
	function admin_init() {
		global $wpdb, $leform;
		if (!current_user_can('manage_options') && !$leform->demo_mode) return;
		if (array_key_exists('leform-action', $_REQUEST)) {
			switch ($_REQUEST['leform-action']) {
				case 'download':
					if ($leform->demo_mode) {
						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
						return;
					}
					$upload_id = intval($_REQUEST["id"]);
					$upload_dir = wp_upload_dir();
					$upload_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE deleted = '0' AND id = '".esc_sql($upload_id)."'", ARRAY_A);
					if (!empty($upload_details)) {
						$filename = $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$upload_details['form_id'].'/'.$upload_details['filename'];
						if (file_exists($filename) && is_file($filename)) {
							error_reporting(0);
							ob_start();
							if(!ini_get('safe_mode')) set_time_limit(0);
							ob_end_clean();
							$length = filesize($filename);
							if (strstr($_SERVER["HTTP_USER_AGENT"],"MSIE")) {
								header("Pragma: public");
								header("Expires: 0");
								header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
								header("Content-type: application-download");
								header("Content-Length: ".$length);
								header("Content-Disposition: attachment; filename=\"".$upload_details['filename_original']."\"");
								header("Content-Transfer-Encoding: binary");
							} else {
								header("Content-type: application-download");
								header("Content-Length: ".$length);
								header("Content-Disposition: attachment; filename=\"".$upload_details['filename_original']."\"");
							}

							$handle_read = fopen($filename, "rb");
							while (!feof($handle_read) && $length > 0) {
								$content = fread($handle_read, 1024);
								echo substr($content, 0, min($length, 1024));
								flush();
								ob_flush();
								$length = $length - strlen($content);
								if ($length < 0) $length = 0;
							}
							fclose($handle_read);
							exit;
						}
					}
					$this->error_message = esc_html__('Requested file not found.', 'leform');
					return;
					break;
				case 'log-record-print':
					$record_id = null;
					if (array_key_exists('id', $_REQUEST)) $record_id = intval($_REQUEST['id']);
					$return_data = $leform->log_record_details_html($record_id, false);
					if ($return_data['status'] != 'OK') {
						$this->error_message = $return_data['message'];
						return;
					}
					echo '
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="robots" content="noindex, nofollow, noarchive, nosnippet">
	<title>'.$return_data['form_name'].' - '.esc_html__('Record', 'leform').' '.$return_data['record-id'].'</title>
	<style>body{font-family:arial;font-size:15px;}body::-webkit-scrollbar{width: 5px;}body::-webkit-scrollbar-track{box-shadow:inset 0 0 6px rgba(0,0,0,0.1);}body::-webkit-scrollbar-thumb{background-color:#26B99A;}div.not-found{margin: 40px;text-align:center;}</style>
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/admin.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
</head>
<body>
	'.$return_data['html'].'
	<script type="text/javascript">window.print();</script>
</body>
</html>';
					exit;
					break;
				case 'log-record-pdf':
					$record_id = null;
					if (array_key_exists('id', $_REQUEST)) $record_id = intval($_REQUEST['id']);
					$return_data = $leform->log_record_details_html($record_id, true);
					if ($return_data['status'] != 'OK') {
						$this->error_message = $return_data['message'];
						return;
					}
					if (!class_exists("TCPDF")) require_once(dirname(dirname(__FILE__)).'/libs/tcpdf/tcpdf.php');
					$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
					$pdf->SetCreator(PDF_CREATOR);
					$pdf->SetAuthor('Green Forms');
					$pdf->SetTitle($return_data['form_name'].' - '.esc_html__('Record', 'leform').' '.$return_data['record-id']);
					$pdf->SetSubject(esc_html__('Record Details', 'leform'));
					$pdf->SetKeywords('Green Forms, Record Details');

					//$pdf->SetHeaderData(null, null, $return_data['form_name'].': '.esc_html__('Record', 'leform').' '.$return_data['record-id'], "by Green Forms", array(0,64,255), array(0,64,128));
					//$pdf->setFooterData(array(0,64,0), array(0,64,128));

					//$pdf->setHeaderFont(Array('freesans', '', 10));
					//$pdf->setFooterFont(Array('freesans', '', 8));
					
					$pdf->setPrintHeader(false);
					$pdf->setPrintFooter(false);

					$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

					$pdf->SetMargins(PDF_MARGIN_LEFT, 15, PDF_MARGIN_RIGHT);
					$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
					$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

					$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

					$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

					$pdf->setFontSubsetting(true);

					$pdf->SetFont('freesans', '', 11, '', true);

					$pdf->AddPage();

					$pdf->writeHTMLCell(0, 0, '', '', $return_data['html'], 0, 1, 0, true, '', true);
					$pdf->Output('record-'.$record_id.'.pdf', 'I');
					exit;
					break;
				case 'transaction-print':
					$record_id = null;
					if (array_key_exists('id', $_REQUEST)) $record_id = intval($_REQUEST['id']);
					$return_data = $leform->transaction_details_html($record_id, true);
					if ($return_data['status'] != 'OK') {
						$this->error_message = $return_data['message'];
						return;
					}
					echo '
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="robots" content="noindex, nofollow, noarchive, nosnippet">
	<title>'.esc_html__('Transaction', 'leform').': '.esc_html($return_data['txn_id']).'</title>
	<style>body{font-family:arial;font-size:15px;}body::-webkit-scrollbar{width: 5px;}body::-webkit-scrollbar-track{box-shadow:inset 0 0 6px rgba(0,0,0,0.1);}body::-webkit-scrollbar-thumb{background-color:#26B99A;}div.not-found{margin: 40px;text-align:center;}</style>
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/admin.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
</head>
<body>
	'.$return_data['html'].'
	<script type="text/javascript">window.print();</script>
</body>
</html>';
					exit;
					break;
				case 'transaction-pdf':
					$record_id = null;
					if (array_key_exists('id', $_REQUEST)) $record_id = intval($_REQUEST['id']);
					$return_data = $leform->transaction_details_html($record_id, true);
					if ($return_data['status'] != 'OK') {
						$this->error_message = $return_data['message'];
						return;
					}
					if (!class_exists("TCPDF")) require_once(dirname(dirname(__FILE__)).'/libs/tcpdf/tcpdf.php');
					$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
					$pdf->SetCreator(PDF_CREATOR);
					$pdf->SetAuthor('Green Forms');
					$pdf->SetTitle(esc_html__('Transaction', 'leform').': '.esc_html($return_data['txn_id']));
					$pdf->SetSubject(esc_html__('Record Details', 'leform'));
					$pdf->SetKeywords('Green Forms, Transaction');

					//$pdf->SetHeaderData(null, null, esc_html__('Transaction', 'leform').': '.esc_html($return_data['txn_id']), "by Green Forms", array(0,64,255), array(0,64,128));
					//$pdf->setFooterData(array(0,64,0), array(0,64,128));

					//$pdf->setHeaderFont(Array('freesans', '', 10));
					//$pdf->setFooterFont(Array('freesans', '', 8));

					$pdf->setPrintHeader(false);
					$pdf->setPrintFooter(false);

					$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

					$pdf->SetMargins(PDF_MARGIN_LEFT, 15, PDF_MARGIN_RIGHT);
					$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
					$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

					$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

					$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

					$pdf->setFontSubsetting(true);

					$pdf->SetFont('freesans', '', 11, '', true);

					$pdf->AddPage();

					$pdf->writeHTMLCell(0, 0, '', '', $return_data['html'], 0, 1, 0, true, '', true);
					$pdf->Output('transaction-'.$record_id.'.pdf', 'I');
					exit;
					break;
				case 'export':
//					if ($leform->demo_mode) {
//						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
//						return;
//					}
					$form_id = intval($_REQUEST["id"]);
					$export = $leform->export($form_id);
					$this->error_message = esc_html__('Requested form not found.', 'leform');
					return;
					break;
				case 'export-style':
					$style_id = intval($_REQUEST["id"]);
					$export = $leform->export_style($style_id);
					$this->error_message = esc_html__('Requested style not found.', 'leform');
					return;
					break;
				case 'import':
					if ($leform->demo_mode) {
						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
						return;
					}
					if (!array_key_exists('leform-file', $_FILES)) return;
					if (is_uploaded_file($_FILES["leform-file"]["tmp_name"])) {
						$dot_pos = strrpos($_FILES["leform-file"]["name"], '.');
						if ($dot_pos === false) {
							$this->error_message = esc_html__('Invalid form file.', 'leform');
							return;
						}
						$ext = strtolower(substr($_FILES["leform-file"]["name"], $dot_pos));
						if ($ext == '.txt') {
							$this->_import_form($_FILES["leform-file"]["tmp_name"]);
							if (!empty($this->error_message)) return;
							$this->success_message = esc_html__('The new form successfully imported.', 'leform');
							return;
						} else if ($ext == '.zip') {
							$str_id = $leform->random_string(16);
							$upload_dir = wp_upload_dir();
							$temp_dir = $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/'.$str_id;
							if (!file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp') || !wp_mkdir_p($temp_dir)) {
								$this->error_message = esc_html__('Make sure that "temp" folder has write permissions.', 'leform');
								return;
							}
							if (!defined('UAP_CORE')) {
								require_once(ABSPATH.'wp-admin/includes/file.php');
								WP_Filesystem();
								$result = unzip_file($_FILES["leform-file"]["tmp_name"], $temp_dir);
							} else {
								$result = new WP_Error();
							}
							if (is_wp_error($result)) {
								try {
									$zip = new ZipArchive;
								} catch(Exception $e){
									$this->error_message = esc_html__('This operation requires ZipArchive module. It is not found.', 'leform');
									return;
								}
								if ($zip->open($_FILES["leform-file"]["tmp_name"]) === TRUE) {
									$zip->extractTo($temp_dir);
									$zip->close();
								} else {
									$this->error_message = esc_html__('Can not unzip archive into folder.', 'leform');
									return;
								}
							}
							$upload_url = trailingslashit($upload_dir['baseurl']).LEFORM_UPLOADS_DIR.'/'.$str_id;
							if (strtolower(substr($upload_url, 0, 7)) == 'http://') $upload_url = substr($upload_url, 5);
							else if (strtolower(substr($upload_url, 0, 8)) == 'https://') $upload_url = substr($upload_url, 6);
							
							$this->_import_form($temp_dir.'/form.txt', $upload_url);
							
							unlink($temp_dir.'/form.txt');
							
							if (!empty($this->error_message)) {
								$this->_remove_dir($temp_dir);
								return;
							}
							$this->success_message = esc_html__('The new form successfully imported.', 'leform');
							return;
						} else {
							$this->error_message = esc_html__('Invalid form file.', 'leform');
							return;
						}
					}
					$this->error_message = esc_html__('Form file was not uploaded.', 'leform');
					return;
					break;
				case 'import-style':
//					if ($leform->demo_mode) {
//						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
//						return;
//					}
					if (!array_key_exists('leform-file', $_FILES)) return;
					if (is_uploaded_file($_FILES["leform-file"]["tmp_name"])) {
						$dot_pos = strrpos($_FILES["leform-file"]["name"], '.');
						if ($dot_pos === false) {
							$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid theme file.', 'leform'));
							echo json_encode($return_object);
							exit;
						}
						$ext = strtolower(substr($_FILES["leform-file"]["name"], $dot_pos));
						if ($ext == '.txt') {
							$return_object = $this->_import_style($_FILES["leform-file"]["tmp_name"]);
							echo json_encode($return_object);
							exit;
						} else if ($ext == '.zip') {
							$str_id = $leform->random_string(16);
							$upload_dir = wp_upload_dir();
							$temp_dir = $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/'.$str_id;
							if (!file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp') || !wp_mkdir_p($temp_dir)) {
								$return_object = array('status' => 'ERROR', 'message' => esc_html__('Make sure that "temp" folder has write permissions.', 'leform'));
								echo json_encode($return_object);
								exit;
							}
							if (!defined('UAP_CORE')) {
								require_once(ABSPATH.'wp-admin/includes/file.php');
								WP_Filesystem();
								$result = unzip_file($_FILES["leform-file"]["tmp_name"], $temp_dir);
							} else {
								$result = new WP_Error();
							}
							if (is_wp_error($result)) {
								try {
									$zip = new ZipArchive;
								} catch(Exception $e){
									$return_object = array('status' => 'ERROR', 'message' => esc_html__('This operation requires ZipArchive module. It is not found.', 'leform'));
									echo json_encode($return_object);
									exit;
								}
								if ($zip->open($_FILES["leform-file"]["tmp_name"]) === TRUE) {
									$zip->extractTo($temp_dir);
									$zip->close();
								} else {
									$return_object = array('status' => 'ERROR', 'message' => esc_html__('Can not unzip archive into folder.', 'leform'));
									echo json_encode($return_object);
									exit;
								}
							}
							$upload_url = trailingslashit($upload_dir['baseurl']).LEFORM_UPLOADS_DIR.'/'.$str_id;
							if (strtolower(substr($upload_url, 0, 7)) == 'http://') $upload_url = substr($upload_url, 5);
							else if (strtolower(substr($upload_url, 0, 8)) == 'https://') $upload_url = substr($upload_url, 6);
							
							$return_object = $this->_import_style($temp_dir.'/style.txt', $upload_url);
							
							unlink($temp_dir.'/style.txt');
							
							echo json_encode($return_object);
							exit;
						} else {
							$return_object = array('status' => 'ERROR', 'message' => esc_html__('Invalid theme file.', 'leform'));
							echo json_encode($return_object);
							exit;
						}
					}
					$return_object = array('status' => 'ERROR', 'message' => esc_html__('Theme file was not uploaded.', 'leform'));
					echo json_encode($return_object);
					exit;
					break;
				case 'export-csv':
					if ($leform->demo_mode) {
						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
						return;
					}
					$form_id = intval($_REQUEST["id"]);
					if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
					$form_object = new leform_form($form_id);
					$form_full = array();
					if (!empty($form_object->id)) {
						$form_object->export_records();
					} else $this->error_message = esc_html__('Requested form not found.', 'leform');
					return;
					break;
				case 'preview':
					$form_id = intval($_REQUEST["id"]);
					if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
					$form_object = new leform_form($form_id, true);
					$content = '<div class="not-found">'.esc_html__('Requested form not found', 'leform').'</div>';
					if (!class_exists("leform_front_class")) include_once(dirname(__FILE__).'/core-front.php');
					if (!empty($form_object->id)) {
						$content = leform_front_class::shortcode_handler(array('id' => $form_object->id, 'preview' => true));
					}
					echo '
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="robots" content="noindex, nofollow, noarchive, nosnippet">
	<title>'.esc_html__('Form Preview', 'leform').': '.(empty($form_object->id) ? esc_html__('Form not found', 'leform') : esc_html($form_object->name)).'</title>
	<style>body{font-family:arial;font-size:15px;}body::-webkit-scrollbar{width: 5px;}body::-webkit-scrollbar-track{box-shadow:inset 0 0 6px rgba(0,0,0,0.1);}body::-webkit-scrollbar-thumb{background-color:#26B99A;}div.not-found{margin: 40px;text-align:center;}</style>
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/preview.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/style.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
					if ($leform->options['fa-enable'] == 'on') {
						if ($leform->options['fa-solid-enable'] == 'on' && $leform->options['fa-regular-enable'] == 'on' && $leform->options['fa-brands-enable'] == 'on') {
							echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-all.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
						} else {
							echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
							if ($leform->options['fa-solid-enable'] == 'on') echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-solid.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
							if ($leform->options['fa-regular-enable'] == 'on') echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-regular.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
							if ($leform->options['fa-brands-enable'] == 'on') echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-brands.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
						}
					} else {
						echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/leform-fa.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
					}
					echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/airdatepicker.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/ion.rangeSlider.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/tooltipster.bundle.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/jquery.min.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/signature_pad.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/ion.rangeSlider.min.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/tooltipster.bundle.min.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/jsep.min.js?ver='.LEFORM_VERSION.'"></script>';
					do_action('leform_preview_head');
					echo '
	<script type="text/javascript">var leform_preview_mode = "on"; var leform_customjs_handlers = {};</script>
</head>
<body>
	<div class="leform-pages-bar">
		<ul class="leform-pages-bar-items">';
					if (!empty($form_object->id)) {
						foreach ($form_object->form_pages as $form_page) {
							echo '
			<li class="leform-pages-bar-item" data-id="'.esc_html($form_page['id']).'" data-name="'.esc_html($form_page['name']).'"><label onclick="return leform_pages_activate(this);">'.esc_html($form_page['name']).'</label></li>';
						}
					}
					echo '
		</ul>
	</div>
	'.$content;
					leform_front_class::front_footer();
					echo '
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/preview.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/leform.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/airdatepicker.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/jquery.mask.min.js?ver='.LEFORM_VERSION.'"></script>
</body>
</html>';
					exit;
					break;
				default:
					break;
			}
		} else if (array_key_exists('leform-gettingstarted', $_REQUEST)) {
			if ($_REQUEST['leform-gettingstarted'] == 'on') {
				$leform->options['gettingstarted-enable'] = 'on';
				update_option('leform-gettingstarted-enable', 'on');
			} else {
				$leform->options['gettingstarted-enable'] = 'off';
				update_option('leform-gettingstarted-enable', 'off');
			}
		}
		if ($leform->options['file-autodelete'] > 0 && array_key_exists($leform->options['file-autodelete'], $leform->file_autodelete_options)) {
			$ids = array();
			$upload_dir = wp_upload_dir();
			$uploads = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE file_deleted != '1' AND created < '".(time()-intval($leform->options['file-autodelete'])*24*3600)."' LIMIT 0, 32", ARRAY_A);
			foreach($uploads as $upload_details) {
				if (file_exists($upload_dir["basedir"].DIRECTORY_SEPARATOR.LEFORM_UPLOADS_DIR.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.$upload_details['form_id'].DIRECTORY_SEPARATOR.$upload_details['filename']) && is_file($upload_dir["basedir"].DIRECTORY_SEPARATOR.LEFORM_UPLOADS_DIR.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.$upload_details['form_id'].DIRECTORY_SEPARATOR.$upload_details['filename'])) {
					$deleted = unlink($upload_dir["basedir"].DIRECTORY_SEPARATOR.LEFORM_UPLOADS_DIR.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.$upload_details['form_id'].DIRECTORY_SEPARATOR.$upload_details['filename']);
					if ($deleted) $ids[] = $upload_details['id'];
				} else $ids[] = $upload_details['id'];
			}
			if (!empty($ids)) {
				$wpdb->query("UPDATE ".$wpdb->prefix."leform_uploads SET file_deleted = '1' WHERE id IN ('".implode("', '", $ids)."')");
			}
		}
	}

	function _import_form($_file, $_url = null) {
		global $leform, $wpdb;
		if (!file_exists($_file)) {
			$this->error_message = esc_html__('Please make sure that you uploaded valid form file.', 'leform');
			return;
		}
		$lines = file($_file);
		if (sizeof($lines) != 3) {
			$this->error_message = esc_html__('Invalid form file.', 'leform');
			return;
		}
		$version = intval(trim($lines[0]));
		if ($version > intval(LEFORM_EXPORT_VERSION)) {
			$this->error_message = esc_html__('Version of the form file is not supported.', 'leform');
			return;
		}
		$md5_hash = trim($lines[1]);
		$form_data = trim($lines[2]);
		$form_data = base64_decode($form_data);
		if (!$form_data || md5($form_data) != $md5_hash) {
			$this->error_message = esc_html__('Form file corrupted.', 'leform');
			return;
		}
		$form_details = json_decode($form_data, true);
		if (!$form_details || !is_array($form_details) || !array_key_exists('name', $form_details) || !array_key_exists('options', $form_details) || !array_key_exists('pages', $form_details) || !array_key_exists('elements', $form_details)) {
			$this->error_message = esc_html__('Form file corrupted.', 'leform');
			return;
		}

		$default_form_options = $leform->default_form_options();
		$form_options = array_merge($default_form_options, $form_details['options']);
		if (!empty($_url)) {
			foreach ($leform->element_properties_meta['settings'] as $key => $element) {
				if (array_key_exists('type', $element) && $element['type'] == 'background-style') {
					if (array_key_exists($key.'-image', $form_options)) {
						$form_options[$key.'-image'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options[$key.'-image']);
					}
				}
			}
			if (array_key_exists('confirmations', $form_options) && !empty($form_options['confirmations'])) {
				foreach ($form_options['confirmations'] as $key => $confirmation) {
					$form_options['confirmations'][$key]['message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['confirmations'][$key]['message']);
				}
			}
			if (array_key_exists('double-email-message', $form_options) && !empty($form_options['double-email-message'])) {
				$form_options['double-email-message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['double-email-message']);
			}
			if (array_key_exists('double-message', $form_options) && !empty($form_options['double-message'])) {
				$form_options['double-message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['double-message']);
			}
			if (array_key_exists('notifications', $form_options) && !empty($form_options['notifications'])) {
				foreach ($form_options['notifications'] as $key => $notification) {
					$form_options['notifications'][$key]['message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['notifications'][$key]['message']);
				}
			}
		}

		$form_pages = array();
		$default_page_options = $leform->default_form_options("page");
		$default_page_confirmation_options = $leform->default_form_options("page-confirmation");
		foreach ($form_details['pages'] as $page_options) {
			if (is_array($page_options)) {
				if ($page_options['type'] == 'page') $page_options = array_merge($default_page_options, $page_options);
				else $page_options = array_merge($default_page_confirmation_options, $page_options);
				$form_pages[] = $page_options;
			}
		}

		$form_elements = array();
		foreach($form_details['elements'] as $element_options) {
			if (is_array($element_options) && array_key_exists('type', $element_options)) {
				$default_element_options = $leform->default_form_options($element_options['type']);
				$element_options = array_merge($default_element_options, $element_options);
				if (!empty($_url)) {
					if ($element_options['type'] == 'html') {
						$element_options['content'] = str_replace('LEFORM-FORM-DIR', $_url, $element_options['content']);
					} else if ($element_options['type'] == 'imageselect') {
						foreach($element_options['options'] as $option_key => $option) {
							$element_options['options'][$option_key]['image'] = str_replace('LEFORM-FORM-DIR', $_url, $element_options['options'][$option_key]['image']);
						}
					}
				}
				$form_elements[] = json_encode($element_options);
			}
		}
		
		$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_forms (name,options,pages,elements,active,created,modified,deleted) VALUES (
			'".esc_sql($form_details['name'])."','".esc_sql(json_encode($form_options))."','".esc_sql(json_encode($form_pages))."','".esc_sql(json_encode($form_elements))."','0','".esc_sql(time())."','".esc_sql(time())."','0')");
		return;
	}

	function _import_style($_file, $_url = null) {
		global $leform, $wpdb;
		if (!file_exists($_file)) {
			$return_object = array('status' => 'ERROR', 'message' => esc_html__('Please make sure that you uploaded valid style file.', 'leform'));
			echo json_encode($return_object);
			exit;
		}
		$lines = file($_file);
		if (sizeof($lines) != 3) {
			$return_object = array('status' => 'ERROR', 'message' => esc_html__('Please make sure that you uploaded valid style file.', 'leform'));
			echo json_encode($return_object);
			exit;
		}
		$version = intval(trim($lines[0]));
		if ($version > intval(LEFORM_EXPORT_VERSION)) {
			$return_object = array('status' => 'ERROR', 'message' => esc_html__('Version of the style file is not supported.', 'leform'));
			echo json_encode($return_object);
			exit;
		}
		$md5_hash = trim($lines[1]);
		$style_data = trim($lines[2]);
		$style_data = base64_decode($style_data);
		if (!$style_data || md5('style-'.$style_data) != $md5_hash) {
			$return_object = array('status' => 'ERROR', 'message' => esc_html__('Style file corrupted.', 'leform'));
			echo json_encode($return_object);
			exit;
		}
		$style_details = json_decode($style_data, true);
		if (!$style_details || !is_array($style_details) || !array_key_exists('name', $style_details) || !array_key_exists('options', $style_details)) {
			$return_object = array('status' => 'ERROR', 'message' => esc_html__('Style file corrupted.', 'leform'));
			echo json_encode($return_object);
			exit;
		}

		$style_options = $style_details['options'];
		if (!empty($_url)) {
			foreach ($leform->element_properties_meta['settings'] as $key => $element) {
				if (array_key_exists('type', $element) && $element['type'] == 'background-style') {
					if (array_key_exists($key.'-image', $style_options)) {
						$style_options[$key.'-image'] = str_replace('LEFORM-FORM-DIR', $_url, $style_options[$key.'-image']);
					}
				}
			}
		}

		$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_styles (name, options, type, deleted) VALUES ('".esc_sql($style_details['name'])."', '".esc_sql(json_encode($style_options))."', '".esc_sql(LEFORM_STYLE_TYPE_USER)."', '0')");
		return array('status' => 'OK', 'message' => esc_html__('The new style successfully imported.', 'leform'), 'id' => $wpdb->insert_id, 'name' => $style_details['name'], 'type' => LEFORM_STYLE_TYPE_USER);
	}

	function _remove_dir($_dir) { 
		$files = array_diff(scandir($_dir), array('.','..')); 
		foreach ($files as $file) { 
			if (is_dir($_dir.'/'.$file)) {
				$this->_remove_dir($_dir.'/'.$file);
			} else {
				unlink($_dir.'/'.$file); 
			}
		}
		return rmdir($_dir);
	}
}
?>