<?php
/* GET/POST integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_post_class {
	var $default_parameters = array(
		"url" => "",
		"type" => "POST",
		"custom-names" => array(),
		"custom-values" => array()
	);
	
	function __construct() {
		if (is_admin()) {
			add_filter('leform_providers', array(&$this, 'providers'), 10, 1);
			add_action('wp_ajax_leform-post-settings-html', array(&$this, "admin_settings_html"));
		}
		add_filter('leform_integrations_do_post', array(&$this, 'front_submit'), 10, 2);
	}
	
	function providers($_providers) {
		if (!array_key_exists("post", $_providers)) $_providers["post"] = esc_html__('GET/POST', 'leform');
		return $_providers;
	}
	
	function admin_settings_html() {
		global $wpdb, $leform;
		if (current_user_can('manage_options')) {
			if (array_key_exists('data', $_REQUEST)) {
				$data = json_decode(base64_decode(trim(stripslashes($_REQUEST['data']))), true);
				if (is_array($data)) $data = array_merge($this->default_parameters, $data);
				else $data = $this->default_parameters;
			} else $data = $this->default_parameters;
			$checkbox_id = $leform->random_string();
			$html = '
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Type', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Select the type of the request.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<select name="type">
						<option value="GET"'.($data['type'] == 'GET' ? ' selected="selected"' : '').'>GET</option>
						<option value="POST"'.($data['type'] == 'POST' ? ' selected="selected"' : '').'>POST</option>
					</select>
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('URL', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Enter URL to send GET/POST requests to.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<input type="text" name="url" value="'.esc_html($data['url']).'" />
				</div>
			</div>
			<div class="leform-properties-item">
				<div class="leform-properties-label">
					<label>'.esc_html__('Query parameters', 'leform').'</label>
				</div>
				<div class="leform-properties-tooltip">
					<i class="fas fa-question-circle leform-tooltip-anchor"></i>
					<div class="leform-tooltip-content">'.esc_html__('Create query parameters and map form fields to them.', 'leform').'</div>
				</div>
				<div class="leform-properties-content">
					<div class="leform-properties-pure leform-integrations-static-inline leform-integrations-custom" data-names="custom-names" data-values="custom-values" data-all="on">
						<table>
							<tr>
								<th>'.esc_html__('Name', 'leform').'</th>
								<td>'.esc_html__('Value', 'leform').'</td>
								<td style="width: 32px;"></td>
							</tr>';
		$i = 0;
		foreach ($data['custom-names'] as $key => $value) {
			if (empty($value)) continue;
			$html .= '
							<tr>
								<th>
									<input type="text" value="'.esc_html($value).'" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="'.esc_html(array_key_exists($key, $data['custom-values']) ? $data['custom-values'][$key] : '').'" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td class="leform-middle-center">'.($i > 0 ? '<a class="leform-integrations-custom-remove" href="#" onclick="jQuery(this).closest(\'tr\').remove(); return false;"><i class="fas fa-trash-alt"></i></a>' : '').'</td>
							</tr>';
			$i++;
		}
		if ($i == 0) {
			$html .= '
							<tr>
								<th>
									<input type="text" value="" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td></td>
							</tr>';
		}
		$html .= '				
							<tr style="display: none;" class="leform-integrations-custom-template">
								<th>
									<input type="text" value="" class="leform-integrations-custom-name widefat" data-custom="on" />
								</th>
								<td>
									<div class="leform-input-shortcode-selector">
										<input type="text" value="" class="leform-integrations-custom-value widefat" data-custom="on" />
										<div class="leform-shortcode-selector" onmouseover="leform_shortcode_selector_set(this)";><span><i class="fas fa-code"></i></span></div>
									</div>
								</td>
								<td class="leform-middle-center"><a class="leform-integrations-custom-remove" href="#" onclick="jQuery(this).closest(\'tr\').remove(); return false;"><i class="fas fa-trash-alt"></i></a></td>
							</tr>
							<tr>
								<td colspan="3">
									<a class="leform-admin-button leform-admin-button-gray leform-admin-button-small" href="#" onclick="return leform_integrations_custom_add(this);"><i class="fas fa-plus"></i><label>'.esc_html__('Add Field', 'leform').'</label></a>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>';
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['html'] = $html;
			echo json_encode($return_object);
		}
		exit;
	}
	
	function front_submit($_result, $_data) {
		global $wpdb, $leform;
		$data = array_merge($this->default_parameters, $_data);
		if (empty($data['url']) || !preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $data['url'])) return $_result;
		if (empty($data['custom-names']) || !is_array($data['custom-names']) || empty($data['custom-values']) || !is_array($data['custom-values'])) return $_result;

		$post_data = array();
		if (!empty($data['custom-names'])) {
			foreach($data['custom-names'] as $key => $name) {
				if (!empty($name)) {
					$post_data[$name] = $data['custom-values'][$key];
				}
			}
		}
		$result = $this->connect($data['url'], $post_data, $data['type']);
		return $_result;
	}
	
	function connect($_url, $_data = array(), $_method = 'POST') {
		$headers = array(
			'Content-Type: application/x-www-form-urlencoded'
		);
		$url = $_url;
		if ($_method == 'GET' && !empty($_data)) {
			if (strpos($url, '?') === false) $url .= '?'.http_build_query($_data);
			else $url .= '&'.http_build_query($_data);
		}
		try {
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
			if ($_method != 'GET') {
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($_data));
			}
			curl_setopt($curl, CURLOPT_TIMEOUT, 10);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
			curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($curl);
			curl_close($curl);
			$result = true;
		} catch (Exception $e) {
			$result = false;
		}
		return $result;
	}
}
$leform_post = new leform_post_class();
?>